def generate_experiment_id(
    name,
    model=None,
    intrasentence_model=None,
    model_name_or_path=None,
    bias_type=None,
    score_type=None,
    data_split=None,
    representation_type=None,
):
    experiment_id = f"{name}"

    # Build the experiment ID.
    if isinstance(model, str):
        experiment_id += f"_m-{model}"
    if isinstance(intrasentence_model, str):
        experiment_id += f"_intra-{intrasentence_model}"
    if isinstance(model_name_or_path, str):
        experiment_id += f"_c-{model_name_or_path}"
    if isinstance(bias_type, str):
        experiment_id += f"_t-{bias_type}"
    if isinstance(score_type, str):
        experiment_id += f"_s-{score_type}"
    if isinstance(data_split, str):
        experiment_id += f"_d-{data_split}"
    if isinstance(representation_type, str):
        experiment_id += f"_r-{representation_type}"

    return experiment_id
