# FewShotNER

This package replicates experiments in [Meta-Learning for Few Shot Named Entity Recognition](https://anonymous.url).

## Dependencies

- [transformers](https://github.com/huggingface/transformers) >= 2.5.1
- [PyTorch](https://pytorch.org/) >= 1.0.1

## Installation
### Standard setup
Install all the dependencies by running
```
pip install -r requirements.txt
```
Then add the `lib` folder to your `PYTHONPATH`.

### Build docker containers for SageMaker
The `Dockerfile.*` files can be used to build docker images for AWS SageMaker. 

## Data
### Pre-processed data
To reproduce the results in the paper, please refer to [data/README.md](data/README.md).

### Processing the data
To reproduce the data processing steps, please refer to [script/README.md](script/README.md).

## Training
For training use the `train_*` python scripts in the `bin` folder. Those scripts are self-documented.

## Evaluation
To evaluate a meta-trained model, use the `eval_*` python scripts corresponding to the model right architecture in the 
`bin` folder. Those scripts are self-documented.

## Licensing
All the code or scripts in `bin`, `lib` and `script` directories are licensed under the [MIT license](LICENSE.txt).

The pre-processed data is license under [CC-BY-SA](data/LICENSE.txt).