/*
 * Decompiled with CFR 0.152.
 */
package utils_bk;

import java.util.HashMap;
import java.util.TreeMap;
import utils_bk.DescStringIntMapComparator;

public class StatOld {
    private int basecol;
    private int classcol;
    private int numtokcol;
    private String[] coldesc_arr;
    private Integer coldesc_arr_count;
    private HashMap<String, HashMap> elements;
    private Integer totalDataAdded;
    private Integer totalGlobalDataAdded;
    private int MAXnumtok;

    public StatOld() {
        this(null, null, null);
    }

    public StatOld(String[] coldesc) {
        this(coldesc, null, null);
    }

    public StatOld(String[] coldesc, String basecol_re) {
        this(coldesc, basecol_re, null);
    }

    public StatOld(String[] coldesc, String basecol_re, String classcol_re) {
        block6: {
            this.coldesc_arr = null;
            this.coldesc_arr_count = 0;
            this.totalDataAdded = 0;
            this.totalGlobalDataAdded = 0;
            this.MAXnumtok = 0;
            this.basecol = -1;
            this.classcol = -1;
            this.numtokcol = -1;
            try {
                if (coldesc == null || coldesc.length < 1) {
                    throw new Exception("Column description is null or empty");
                }
                this.coldesc_arr = coldesc;
                this.coldesc_arr_count = coldesc.length;
                if (basecol_re != null) {
                    this.basecol = this.getColumn(basecol_re);
                }
                if (classcol_re != null) {
                    this.classcol = this.getColumn(classcol_re);
                }
                if (this.basecol == -1) {
                    this.basecol = 0;
                }
                this.numtokcol = this.getColumn("numtok");
                this.elements = new HashMap();
            }
            catch (Exception e) {
                System.err.println("Errors found (" + this.getClass().getSimpleName() + "):\n\t" + e.toString() + "\n");
                if (System.getProperty("DEBUG") == null || !System.getProperty("DEBUG").equalsIgnoreCase("true")) break block6;
                e.printStackTrace(System.err);
                System.exit(1);
            }
        }
    }

    public int getColumn(String colname_re) {
        for (int i = 0; i < this.coldesc_arr_count; ++i) {
            if (!this.coldesc_arr[i].matches(colname_re)) continue;
            return i;
        }
        return -1;
    }

    public void addData(String[] data) {
        block10: {
            Integer n = this.totalDataAdded;
            Integer n2 = this.totalDataAdded = Integer.valueOf(this.totalDataAdded + 1);
            if (this.numtokcol != -1 && Integer.parseInt(data[this.numtokcol]) > this.MAXnumtok) {
                this.MAXnumtok = Integer.parseInt(data[this.numtokcol]);
            }
            try {
                HashMap<String, HashMap> dataMap = new HashMap<String, HashMap>();
                if (data.length != this.coldesc_arr_count) {
                    throw new Exception("Malformed data");
                }
                String datakey = this.classcol != -1 ? data[this.basecol] + "-" + data[this.classcol] : data[this.basecol];
                if (this.elements.containsKey(datakey)) {
                    HashMap colsMap = this.elements.get(datakey);
                    for (int col = 0; col < this.coldesc_arr_count; ++col) {
                        if (col == this.basecol || col == this.classcol) continue;
                        HashMap colMap = (HashMap)colsMap.get(this.coldesc_arr[col]);
                        Integer colMapValue = (Integer)colMap.get(data[col]);
                        if (colMapValue != null) {
                            Integer n3 = colMapValue;
                            Integer n4 = colMapValue = Integer.valueOf(colMapValue + 1);
                        } else {
                            colMapValue = 1;
                        }
                        colMap.put(data[col], colMapValue);
                    }
                    final Integer totalValue = (Integer)((HashMap)colsMap.get("total")).get("total") + 1;
                    colsMap.put("total", new HashMap<String, Integer>(){
                        {
                            this.put("total", totalValue);
                        }
                    });
                } else {
                    for (int col = 0; col < this.coldesc_arr_count; ++col) {
                        if (col == this.basecol || col == this.classcol) continue;
                        final String tempdata = data[col];
                        dataMap.put(this.coldesc_arr[col], new HashMap<String, Integer>(){
                            {
                                this.put(tempdata, 1);
                            }
                        });
                    }
                    dataMap.put("total", new HashMap<String, Integer>(){
                        {
                            this.put("total", 1);
                        }
                    });
                    this.elements.put(datakey, dataMap);
                }
            }
            catch (Exception e) {
                System.err.println("Errors found (" + this.getClass().getSimpleName() + "):\n\t" + e.toString() + "\n");
                if (System.getProperty("DEBUG") == null || !System.getProperty("DEBUG").equalsIgnoreCase("true")) break block10;
                e.printStackTrace(System.err);
                System.exit(1);
            }
        }
    }

    public void addGLOBALdata(String statkey, String statsubkey) {
        block6: {
            try {
                HashMap colMapGlobal;
                HashMap colsMapGlobal;
                if (this.elements.get("GLOBAL") == null) {
                    this.createGLOBALelement();
                }
                if ((colsMapGlobal = this.elements.get("GLOBAL")).get(statkey) != null && (colMapGlobal = (HashMap)colsMapGlobal.get(statkey)).get(statsubkey) != null) {
                    Integer n;
                    Integer colMapValue = (Integer)colMapGlobal.get(statsubkey);
                    if (colMapValue != null) {
                        Integer n2 = colMapValue;
                        n = colMapValue = Integer.valueOf(colMapValue + 1);
                    } else {
                        colMapValue = 1;
                    }
                    final Integer totalValue = (Integer)((HashMap)colsMapGlobal.get("total")).get("total") + 1;
                    colsMapGlobal.put("total", new HashMap<String, Integer>(){
                        {
                            this.put("total", totalValue);
                        }
                    });
                    colMapGlobal.put(statsubkey, colMapValue);
                    n = this.totalGlobalDataAdded;
                    Integer n3 = this.totalGlobalDataAdded = Integer.valueOf(this.totalGlobalDataAdded + 1);
                }
            }
            catch (Exception e) {
                System.err.println("Errors found (" + this.getClass().getSimpleName() + "):\n\t" + e.toString() + "\n");
                if (System.getProperty("DEBUG") == null || !System.getProperty("DEBUG").equalsIgnoreCase("true")) break block6;
                e.printStackTrace(System.err);
                System.exit(1);
            }
        }
    }

    public void print() {
        this.print(1);
    }

    public void print(int minpercent) {
        System.err.println("\nPrinting Statistics (total Data " + this.totalDataAdded + ")\n-------------------------");
        if (this.elements.get("GLOBAL") != null) {
            this.printGlobal(minpercent);
        } else {
            this.printSimple(minpercent);
        }
    }

    public void printSimple(int minpercent) {
        for (String current_key : this.elements.keySet()) {
            HashMap colsMap = this.elements.get(current_key);
            Integer elementTotal = (Integer)((HashMap)colsMap.get("total")).get("total");
            System.out.println(current_key + "(" + elementTotal + ")");
            for (String cols_key : colsMap.keySet()) {
                if (cols_key.equalsIgnoreCase("total")) continue;
                System.out.println("\t" + cols_key);
                HashMap colMap = (HashMap)colsMap.get(cols_key);
                TreeMap sortedColMap = new TreeMap(new DescStringIntMapComparator(colMap));
                sortedColMap.putAll(colMap);
                for (String col_key : sortedColMap.keySet()) {
                    Integer colValue = (Integer)colMap.get(col_key);
                    int colPercent = (int)Math.round((double)colValue.intValue() / (double)elementTotal.intValue() * 100.0);
                    if (colPercent < minpercent) continue;
                    System.out.println("\t\t" + col_key + "\t" + colPercent + "%" + " (" + colValue + ")");
                }
                System.out.println();
            }
            System.out.println();
        }
        System.out.println();
    }

    public void printGlobal(int minpercent) {
        HashMap colsMapGlobal = this.elements.get("GLOBAL");
        for (String current_key : this.elements.keySet()) {
            if (current_key.equals("GLOBAL")) continue;
            HashMap colsMap = this.elements.get(current_key);
            Integer elementTotal = (Integer)((HashMap)colsMap.get("total")).get("total");
            System.out.println(current_key + "(" + elementTotal + ")");
            for (String cols_key : colsMap.keySet()) {
                if (cols_key.equalsIgnoreCase("total")) continue;
                System.out.println("\t" + cols_key);
                HashMap colMap = (HashMap)colsMap.get(cols_key);
                HashMap colMapGlobal = (HashMap)colsMapGlobal.get(cols_key);
                TreeMap sortedColMap = new TreeMap(new DescStringIntMapComparator(colMap));
                sortedColMap.putAll(colMap);
                for (String col_key : sortedColMap.keySet()) {
                    Integer colValue = (Integer)colMap.get(col_key);
                    Integer globalValue = (Integer)colMapGlobal.get(col_key);
                    int colPercent = (int)Math.round((double)colValue.intValue() / (double)elementTotal.intValue() * 100.0);
                    if (colPercent < minpercent) continue;
                    double globPercent = (double)((int)Math.round((double)colValue.intValue() / (double)globalValue.intValue() * 1000.0)) / 10.0;
                    System.out.print("\t\t" + col_key + "\t" + colPercent + "%" + " (" + colValue + ")");
                    if (globPercent > 0.0) {
                        System.out.print("-> " + globPercent + "% of corpus \"" + col_key + "\" (" + globalValue + ")");
                    }
                    System.out.println();
                }
                System.out.println();
            }
            System.out.println();
        }
        System.out.println();
    }

    public void createGLOBALelement() {
        HashMap<String, HashMap> colsMapGlobal = new HashMap<String, HashMap>();
        for (String current_key : this.elements.keySet()) {
            HashMap colMapGlobal;
            HashMap colMap;
            HashMap colsMap = this.elements.get(current_key);
            if (colsMapGlobal.isEmpty()) {
                for (String cols_key : colsMap.keySet()) {
                    colMap = (HashMap)colsMap.get(cols_key);
                    colMapGlobal = new HashMap();
                    for (String col_key : colMap.keySet()) {
                        colMapGlobal.put(col_key, 0);
                    }
                    colsMapGlobal.put(cols_key, colMapGlobal);
                }
            }
            for (String cols_key : colsMap.keySet()) {
                colMap = (HashMap)colsMap.get(cols_key);
                colMapGlobal = (HashMap)colsMapGlobal.get(cols_key);
                for (String col_key : colMap.keySet()) {
                    colMapGlobal.put(col_key, 0);
                }
                colsMapGlobal.put(cols_key, colMapGlobal);
            }
        }
        this.elements.put("GLOBAL", colsMapGlobal);
    }

    public int getMAXnumtok() {
        return this.MAXnumtok;
    }
}

