/*
 * Decompiled with CFR 0.152.
 */
package matetools.is2.modification.treesegs;

import java.util.ArrayList;
import java.util.List;
import java.util.Random;
import matetools.is2.data.SentenceData09;
import matetools.is2.modification.treesegs.TreeSegmentation;

public class RandomTreeSegmentation
implements TreeSegmentation {
    static String ROOT = "<virtual-root>";
    static String ROOT_LEMMA = "<virtual-lemma>";
    static String ROOT_POS = "<virtual-pos>";
    static String NO_TYPE = "<no-type>";
    int maxHeight = 4;
    int minFullHeight = 2;
    double branchRate = 0.75;
    public String[] virtualForms;
    public String[] virtualLemmas;
    public String[] virtualPlemmas;
    public String[] virtualGpos;
    public String[] virtualPpos;
    Random rand = new Random(42L);

    @Override
    public List<SentenceData09> segment(SentenceData09 sent) {
        this.setVirtuals(sent);
        ArrayList<SentenceData09> ret = new ArrayList<SentenceData09>();
        SimpleTree root = this.buildSimpleTree(sent);
        ArrayList<SimpleTree> segTrees = new ArrayList<SimpleTree>();
        this.segmentRecursive(root, this.maxHeight, this.minFullHeight, segTrees);
        for (SimpleTree tree : segTrees) {
            ret.add(this.toSentenceData09(sent, tree));
        }
        return ret;
    }

    private void setVirtuals(SentenceData09 sent) {
        this.virtualForms = (String[])sent.forms.clone();
        this.virtualPlemmas = (String[])sent.plemmas.clone();
        this.virtualLemmas = (String[])sent.lemmas.clone();
        this.virtualGpos = (String[])sent.gpos.clone();
        this.virtualPpos = (String[])sent.ppos.clone();
        this.virtualForms[0] = ROOT;
        this.virtualPlemmas[0] = ROOT_LEMMA;
        this.virtualLemmas[0] = ROOT_LEMMA;
        this.virtualGpos[0] = ROOT_POS;
        this.virtualPpos[0] = ROOT_POS;
    }

    private SentenceData09 toSentenceData09(SentenceData09 sent, SimpleTree tree) {
        ArrayList<SimpleTree> nodes = new ArrayList<SimpleTree>();
        this.getAllNodes(tree, nodes);
        SentenceData09 ret = new SentenceData09();
        ret.forms = sent.forms;
        ret.gpos = sent.gpos;
        ret.ppos = sent.ppos;
        ret.plemmas = sent.plemmas;
        ret.plabels = sent.plabels;
        ret.lemmas = sent.lemmas;
        ret.heads = sent.heads;
        ret.pheads = sent.pheads;
        ret.ofeats = sent.ofeats;
        ret.pfeats = sent.pfeats;
        ret.labels = sent.labels;
        ret.fillp = sent.fillp;
        ret.id = sent.id;
        int offset = 0;
        int length = nodes.size();
        if (tree.node != 0) {
            offset = 1;
            ret.forms = this.virtualForms;
            ret.gpos = this.virtualGpos;
            ret.ppos = this.virtualPpos;
            ret.plemmas = this.virtualPlemmas;
            ret.lemmas = this.virtualLemmas;
        }
        ret.heads = new int[length + offset];
        ret.heads[0] = -1;
        ret.originalPosition = new int[length + offset];
        ret.originalPosition[0] = 0;
        int j = 0;
        while (j < length) {
            SimpleTree node = (SimpleTree)nodes.get(j);
            int idx = node.node;
            if (node == tree) {
                ret.heads[j + offset] = -1 + offset;
            } else {
                int i = 0;
                while (i < length) {
                    if (sent.heads[idx] == ((SimpleTree)nodes.get((int)i)).node) {
                        ret.heads[j + offset] = i + offset;
                        break;
                    }
                    ++i;
                }
            }
            ret.originalPosition[j + offset] = idx;
            ++j;
        }
        return ret;
    }

    private void getAllNodes(SimpleTree tree, List<SimpleTree> nodes) {
        if (tree.children.isEmpty()) {
            nodes.add(tree);
            return;
        }
        boolean rootAdded = false;
        for (SimpleTree c : tree.children) {
            if (!rootAdded && c.node > tree.node) {
                nodes.add(tree);
                rootAdded = true;
            }
            this.getAllNodes(c, nodes);
        }
        if (!rootAdded) {
            nodes.add(tree);
        }
    }

    private void segmentRecursive(SimpleTree root, int maxHeight, int minFullHeight, List<SimpleTree> segTrees) {
        if (root.children.isEmpty()) {
            return;
        }
        if (maxHeight == this.maxHeight) {
            segTrees.add(root);
        }
        if (maxHeight == 1) {
            SimpleTree newRoot = root.clone();
            root.children = new ArrayList<SimpleTree>();
            this.segmentRecursive(newRoot, this.maxHeight, this.minFullHeight, segTrees);
            return;
        }
        for (SimpleTree child : root.children) {
            double branch = this.rand.nextDouble();
            if (minFullHeight > 1 || branch < this.branchRate) {
                this.segmentRecursive(child, maxHeight - 1, minFullHeight - 1, segTrees);
                continue;
            }
            SimpleTree newChild = child.clone();
            child.children = new ArrayList<SimpleTree>();
            this.segmentRecursive(newChild, this.maxHeight, this.minFullHeight, segTrees);
        }
    }

    private SimpleTree buildSimpleTree(SentenceData09 sent) {
        int[] heads = sent.heads;
        SimpleTree[] trees = new SimpleTree[heads.length];
        int i = 0;
        while (i < heads.length) {
            trees[i] = new SimpleTree(i);
            ++i;
        }
        i = 1;
        while (i < heads.length) {
            trees[heads[i]].children.add(trees[i]);
            ++i;
        }
        return trees[0];
    }

    public static SentenceData09 toSegmentSent(SentenceData09 sent) {
        SentenceData09 ret = new SentenceData09();
        int length = sent.heads.length;
        ret.forms = new String[length];
        ret.gpos = new String[length];
        ret.ppos = new String[length];
        ret.plemmas = new String[length];
        ret.plabels = new String[length];
        ret.lemmas = new String[length];
        ret.heads = sent.heads;
        ret.pheads = sent.pheads;
        ret.ofeats = new String[length];
        ret.pfeats = new String[length];
        ret.labels = new String[length];
        ret.fillp = new String[length];
        ret.id = new String[length];
        int i = 0;
        while (i < length) {
            ret.forms[i] = sent.forms[sent.originalPosition[i]];
            ret.gpos[i] = sent.gpos[sent.originalPosition[i]];
            ret.ppos[i] = sent.ppos[sent.originalPosition[i]];
            ret.plemmas[i] = sent.plemmas[sent.originalPosition[i]];
            ret.plabels[i] = sent.plabels[sent.originalPosition[i]];
            ret.lemmas[i] = sent.lemmas[sent.originalPosition[i]];
            ret.ofeats[i] = sent.ofeats[sent.originalPosition[i]];
            ret.pfeats[i] = sent.pfeats[sent.originalPosition[i]];
            ret.labels[i] = sent.labels[sent.originalPosition[i]];
            ret.fillp[i] = sent.fillp[sent.originalPosition[i]];
            ret.id[i] = Integer.toString(i);
            ++i;
        }
        return ret;
    }

    class SimpleTree
    implements Cloneable {
        int node;
        List<SimpleTree> children;

        SimpleTree(int node) {
            this(node, new ArrayList<SimpleTree>());
        }

        SimpleTree(int node, List<SimpleTree> children) {
            this.node = node;
            this.children = children;
        }

        public SimpleTree clone() {
            try {
                return (SimpleTree)super.clone();
            }
            catch (CloneNotSupportedException e) {
                throw new RuntimeException(e);
            }
        }
    }
}

