/*
 * Decompiled with CFR 0.152.
 */
package matetools.is2.modification.costsensitive;

import fig.basic.LogInfo;
import matetools.is2.data.FV;
import matetools.is2.data.Instances;
import matetools.is2.data.Parse;
import matetools.is2.modification.costsensitive.CostStrategy;
import matetools.is2.parser.ParametersFloat;

public class UptrainingCostStrategy
implements CostStrategy {
    public static double C = 1.0;
    public static double confidence = 0.1;

    public double cost(Instances is, int n, Parse d) {
        short[] gold = is.heads[n];
        short[] sys = d.heads;
        double wrong = 0.0;
        int i = 0;
        while (i < gold.length) {
            if (gold[i] != sys[i]) {
                wrong += 1.0;
            }
            ++i;
        }
        wrong /= (double)gold.length;
        if (is.additional[n]) {
            wrong *= 1.5707963267948966 - Math.atan((double)gold.length * confidence);
        }
        return wrong;
    }

    @Override
    public double calculate(Instances is, int n, Parse d, ParametersFloat curParams, FV act, FV pred) {
        double uas = this.cost(is, n, d);
        if (uas == 0.0) {
            return 0.0;
        }
        float lam_dist = curParams.getScore(act) - curParams.getScore(pred);
        FV dist = act.getDistVector(pred);
        double norm = dist.dotProduct(dist);
        double u = Math.sqrt(uas) - (double)lam_dist;
        double l = norm + 0.5 / C;
        if (is.additional[n]) {
            return u / l * 0.1;
        }
        return u / l;
    }

    public static void main(String[] args) {
        LogInfo.logs(1.0 / (1.5707963267948966 - Math.atan(1.0)));
        LogInfo.logs(1.5707963267948966 - Math.atan(10.0));
        LogInfo.logs(1.5707963267948966 - Math.atan(100.0));
    }
}

