/*
 * Decompiled with CFR 0.152.
 */
package babel.util.language;

import babel.util.language.LangDetectionResult;
import babel.util.language.LangDetector;
import babel.util.language.Language;
import java.io.BufferedReader;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.net.HttpURLConnection;
import java.net.URL;
import java.net.URLEncoder;
import org.json.JSONObject;

public class GoogleLangDetector
implements LangDetector {
    protected static final int MAX_TEXT_LENGTH = 1800;
    protected static final String URL = "http://ajax.googleapis.com/ajax/services/language/detect?v=1.0&q=";
    protected static final String ENCODING = "UTF-8";
    protected static byte ESCAPE_CHAR = (byte)37;
    protected String m_referrer;

    public GoogleLangDetector(String referrer) {
        if (referrer == null || referrer.length() == 0) {
            throw new IllegalArgumentException("Referrer must be supplied.");
        }
        this.m_referrer = referrer;
    }

    @Override
    public LangDetectionResult detect(String text) throws Exception {
        if (text == null || text.length() == 0) {
            return new LangDetectionResult(null);
        }
        JSONObject json = this.retrieveJSON(new URL(URL + this.encodeAndTrim(text)));
        return new LangDetectionResult(Language.fromString(json.getJSONObject("responseData").getString("language")), json.getJSONObject("responseData").getDouble("confidence"), json.getJSONObject("responseData").getBoolean("isReliable"));
    }

    protected String encodeAndTrim(String str) throws Exception {
        int escIdx;
        String shortStr = URLEncoder.encode(str, ENCODING);
        if (shortStr.length() > 1800 && (escIdx = (shortStr = shortStr.substring(0, 1800)).lastIndexOf(ESCAPE_CHAR)) > 0 && 1800 - escIdx < 3) {
            shortStr = shortStr.substring(0, escIdx);
        }
        return shortStr;
    }

    protected JSONObject retrieveJSON(URL url) throws Exception {
        JSONObject jSONObject;
        HttpURLConnection uc = (HttpURLConnection)url.openConnection();
        uc.setRequestProperty("referer", this.m_referrer);
        uc.setRequestMethod("GET");
        uc.setDoOutput(true);
        try {
            String result = this.inputStreamToString(uc.getInputStream());
            jSONObject = new JSONObject(result);
        }
        catch (Throwable throwable) {
            try {
                uc.getInputStream().close();
                if (uc.getErrorStream() != null) {
                    uc.getErrorStream().close();
                }
                throw throwable;
            }
            catch (Exception ex) {
                throw new Exception("Error retrieving detection result : " + ex.toString(), ex);
            }
        }
        uc.getInputStream().close();
        if (uc.getErrorStream() != null) {
            uc.getErrorStream().close();
        }
        return jSONObject;
    }

    private String inputStreamToString(InputStream inputStream) throws Exception {
        StringBuilder outputBuilder = new StringBuilder();
        try {
            if (inputStream != null) {
                String string;
                BufferedReader reader = new BufferedReader(new InputStreamReader(inputStream, ENCODING));
                while ((string = reader.readLine()) != null) {
                    outputBuilder.append(string).append('\n');
                }
            }
        }
        catch (Exception ex) {
            throw new Exception("Error reading translation stream : " + ex.toString(), ex);
        }
        return outputBuilder.toString();
    }
}

