/*
 * Decompiled with CFR 0.152.
 */
package org.maltparser.parser;

import java.util.HashSet;
import java.util.Iterator;
import java.util.Set;
import java.util.SortedSet;
import java.util.Stack;
import java.util.TreeSet;
import org.maltparser.core.exception.MaltChainedException;
import org.maltparser.core.syntaxgraph.DependencyGraph;
import org.maltparser.core.syntaxgraph.DependencyStructure;
import org.maltparser.core.syntaxgraph.edge.Edge;
import org.maltparser.core.syntaxgraph.edge.GraphEdge;
import org.maltparser.core.syntaxgraph.node.DependencyNode;
import org.maltparser.core.syntaxgraph.node.Node;
import org.maltparser.core.syntaxgraph.node.TokenNode;
import org.maltparser.parser.Algorithm;
import org.maltparser.parser.DependencyParserConfig;
import org.maltparser.parser.Parser;
import org.maltparser.parser.SingleMalt;
import org.maltparser.parser.algorithm.planar3TLabelStrat.Planar3TLabelStratConfig;
import org.maltparser.parser.algorithm.twoplanar3T.TwoPlanar3TConfig;
import org.maltparser.parser.algorithm.ucovington.UcovingtonConfig;
import org.maltparser.parser.guide.ClassifierGuide;
import org.maltparser.parser.guide.SingleGuide;
import org.maltparser.parser.history.GuideHistory;
import org.maltparser.parser.history.action.GuideDecision;
import org.maltparser.parser.history.action.GuideUserAction;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class DeterministicParser
extends Parser {
    private int parseCount;

    public DeterministicParser(DependencyParserConfig manager) throws MaltChainedException {
        super(manager);
        this.setManager(manager);
        this.initParserState(1);
        ((SingleMalt)manager).addRegistry(Algorithm.class, this);
        this.setGuide(new SingleGuide(manager, (GuideHistory)((Object)this.parserState.getHistory()), ClassifierGuide.GuideMode.CLASSIFY));
    }

    @Override
    public DependencyStructure parse(DependencyStructure parseDependencyGraph) throws MaltChainedException {
        String opcion = "label";
        if (this.parserState.getTransitionSystem().getName().compareTo("two-planar 3t arc-eager") == 0) {
            opcion = ((TwoPlanar3TConfig)this.parserState.getConfiguration()).getMode();
        }
        if (this.parserState.getTransitionSystem().getName().compareTo("ucovnonproj") == 0) {
            opcion = ((UcovingtonConfig)this.parserState.getConfiguration()).getMode();
        }
        String opcion2 = "old";
        if (this.parserState.getTransitionSystem().getName().compareTo("two-planar 3t arc-eager") == 0) {
            opcion2 = ((TwoPlanar3TConfig)this.parserState.getConfiguration()).getHeuristic();
        }
        if (this.parserState.getTransitionSystem().getName().compareTo("planar 3t label strategy arc-eager") == 0) {
            opcion2 = ((Planar3TLabelStratConfig)this.parserState.getConfiguration()).getHeuristic();
        }
        if (this.parserState.getTransitionSystem().getName().compareTo("ucovnonproj") == 0) {
            opcion2 = ((UcovingtonConfig)this.parserState.getConfiguration()).getHeuristic();
        }
        this.parserState.clear();
        this.parserState.initialize(parseDependencyGraph);
        if (this.parserState.getTransitionSystem().getName().compareTo("planar 3t arc-eager") == 0 || this.parserState.getTransitionSystem().getName().compareTo("planar 3t label strategy arc-eager") == 0 || this.parserState.getTransitionSystem().getName().compareTo("two-planar 3t arc-eager") == 0 || this.parserState.getTransitionSystem().getName().compareTo("ucovnonproj") == 0) {
            ((DependencyGraph)parseDependencyGraph).setSingleHeadedConstraint(false);
        }
        this.currentParserConfiguration = this.parserState.getConfiguration();
        ++this.parseCount;
        if (this.diagnostics) {
            this.writeToDiaFile(this.parseCount + "");
        }
        while (!this.parserState.isTerminalState()) {
            GuideUserAction action = this.parserState.getTransitionSystem().getDeterministicAction(this.parserState.getHistory(), this.currentParserConfiguration);
            if (action == null) {
                action = this.predict();
            } else if (this.diagnostics) {
                this.writeToDiaFile(" *");
            }
            if (this.diagnostics) {
                this.writeToDiaFile(" " + this.parserState.getTransitionSystem().getActionString(action));
            }
            this.parserState.apply(action);
        }
        if (this.parserState.getTransitionSystem().getName().compareTo("planar 3t arc-eager") == 0 || this.parserState.getTransitionSystem().getName().compareTo("planar 3t label strategy arc-eager") == 0 || this.parserState.getTransitionSystem().getName().compareTo("two-planar 3t arc-eager") == 0 || this.parserState.getTransitionSystem().getName().compareTo("ucovnonproj") == 0) {
            this.copyEdgesForPlanar3T(this.currentParserConfiguration.getDependencyGraph(), parseDependencyGraph);
            this.copyDynamicInput(this.currentParserConfiguration.getDependencyGraph(), parseDependencyGraph);
        } else {
            this.copyEdges(this.currentParserConfiguration.getDependencyGraph(), parseDependencyGraph);
            this.copyDynamicInput(this.currentParserConfiguration.getDependencyGraph(), parseDependencyGraph);
        }
        if (opcion.compareTo("root") == 0) {
            if (this.parserState.getTransitionSystem().getName().compareTo("planar 3t arc-eager") == 0 || this.parserState.getTransitionSystem().getName().compareTo("two-planar 3t arc-eager") == 0 || this.parserState.getTransitionSystem().getName().compareTo("ucovnonproj") == 0) {
                this.graphToDependencyTree(parseDependencyGraph);
                if (!parseDependencyGraph.isConnected()) {
                    this.linkNoConectedComponent(parseDependencyGraph);
                    this.graphToDependencyTree(parseDependencyGraph);
                }
            } else if (this.parserState.getTransitionSystem().getName().compareTo("planar 3t label strategy arc-eager") == 0) {
                this.labeledUndirectedGraphToDepTree(parseDependencyGraph);
                parseDependencyGraph.linkAllTreesToRoot();
                this.removeGuiltyRootLinks(parseDependencyGraph);
                if (!parseDependencyGraph.isSingleHeaded()) {
                    this.solveDoubleHeadProblem(parseDependencyGraph);
                }
                if (!parseDependencyGraph.isSingleHeaded()) {
                    this.solveDoubleHeadProblemAgain(parseDependencyGraph);
                }
            } else {
                parseDependencyGraph.linkAllTreesToRoot();
            }
        } else if (this.parserState.getTransitionSystem().getName().compareTo("planar 3t arc-eager") == 0) {
            this.graphToDependencyTree(parseDependencyGraph);
            if (!parseDependencyGraph.isConnected()) {
                this.linkNoConectedComponent(parseDependencyGraph);
                this.graphToDependencyTree(parseDependencyGraph);
            }
        } else if (this.parserState.getTransitionSystem().getName().compareTo("planar 3t label strategy arc-eager") == 0 || this.parserState.getTransitionSystem().getName().compareTo("two-planar 3t arc-eager") == 0 || this.parserState.getTransitionSystem().getName().compareTo("ucovnonproj") == 0) {
            this.labeledUndirectedGraphToDepTree(parseDependencyGraph);
            if (opcion2.compareTo("old") == 0) {
                parseDependencyGraph.linkAllTreesToRoot();
                this.removeGuiltyRootLinks(parseDependencyGraph);
                if (!parseDependencyGraph.isSingleHeaded()) {
                    this.solveDoubleHeadProblem(parseDependencyGraph);
                }
                if (!parseDependencyGraph.isSingleHeaded()) {
                    this.solveDoubleHeadProblemAgain(parseDependencyGraph);
                }
            } else {
                this.linkNoConectedComponent(parseDependencyGraph);
                this.holdSingleHead(parseDependencyGraph);
            }
        } else {
            parseDependencyGraph.linkAllTreesToRoot();
        }
        if (this.diagnostics) {
            this.writeToDiaFile("\n");
        }
        return parseDependencyGraph;
    }

    private GuideUserAction predict() throws MaltChainedException {
        GuideUserAction currentAction = this.parserState.getHistory().getEmptyGuideUserAction();
        try {
            this.classifierGuide.predict((GuideDecision)((Object)currentAction));
            while (!this.parserState.permissible(currentAction)) {
                if (this.classifierGuide.predictFromKBestList((GuideDecision)((Object)currentAction))) continue;
                currentAction = this.getParserState().getTransitionSystem().defaultAction(this.parserState.getHistory(), this.currentParserConfiguration);
                break;
            }
        }
        catch (NullPointerException e) {
            throw new MaltChainedException("The guide cannot be found. ", e);
        }
        return currentAction;
    }

    @Override
    public void terminate() throws MaltChainedException {
        if (this.diagnostics) {
            this.closeDiaWriter();
        }
    }

    private void graphToDependencyTree(DependencyStructure graph) throws MaltChainedException {
        SortedSet<Edge> arcos = graph.getEdges();
        Iterator itR = arcos.iterator();
        Stack<Edge> roots = new Stack<Edge>();
        Edge arco = null;
        while (itR.hasNext()) {
            arco = (Edge)itR.next();
            if (arco.getSource().getIndex() != 0) continue;
            roots.push(arco);
        }
        while (!roots.isEmpty()) {
            arco = (Edge)roots.pop();
            Stack<Node> destinos = new Stack<Node>();
            Stack<Node> cabezaDestinos = new Stack<Node>();
            destinos.push(arco.getTarget());
            cabezaDestinos.push(arco.getSource());
            while (!destinos.isEmpty()) {
                Node puntoDePartida = (Node)destinos.pop();
                Node cabezaPDP = (Node)cabezaDestinos.pop();
                Iterator<Edge> it = puntoDePartida.getOutgoingEdgeIterator();
                while (it.hasNext()) {
                    arco = it.next();
                    destinos.push(arco.getTarget());
                    cabezaDestinos.push(arco.getSource());
                }
                Iterator<Edge> itI = puntoDePartida.getIncomingEdgeIterator();
                TreeSet<Edge> modificar = new TreeSet<Edge>();
                while (itI.hasNext()) {
                    arco = itI.next();
                    if (arco.getSource().getIndex() == cabezaPDP.getIndex() || arco.getSource().getIndex() == 0) continue;
                    destinos.push(arco.getSource());
                    cabezaDestinos.push(arco.getTarget());
                    modificar.add(arco);
                }
                Edge arcoAModif = null;
                while (!modificar.isEmpty()) {
                    arcoAModif = (Edge)modificar.first();
                    ((GraphEdge)arcoAModif).changeSense(arcoAModif.getTarget(), arcoAModif.getSource(), 1);
                    modificar.remove(arcoAModif);
                }
            }
        }
    }

    private void removeGuiltyRootLinks(DependencyStructure graph) throws MaltChainedException {
        SortedSet<Integer> nodos = graph.getTokenIndices();
        block0: for (Integer nodo : nodos) {
            if (!this.checkIfNodesAreRelated(graph, 0, nodo) || graph.getTokenNode(nodo).getHeads().size() <= 1) continue;
            SortedSet<Integer> nodosE = graph.getTokenIndices();
            for (Integer nodoE : nodosE) {
                if (!this.checkIfNodesAreRelated(graph, 0, nodoE) || nodoE.compareTo(nodo) == 0 || graph.getTokenNode(nodoE).getHeads().size() != 1) continue;
                this.getEdgeGraph(graph, 0, nodoE).addLabel(graph.getSymbolTables().getSymbolTable("DEPREL"), "ROOT");
                GraphEdge a = (GraphEdge)this.getEdgeGraph(graph, 0, nodo);
                a.changeSense(a.getSource(), (Node)((Object)graph.getTokenNode(nodoE)), 1);
                this.getEdgeGraph(graph, 0, nodoE).addLabel(graph.getSymbolTables().getSymbolTable("DEPREL"), "ROOT");
                continue block0;
            }
        }
    }

    private boolean checkIfNodesAreRelated(DependencyStructure dg, int index1, int index2) throws MaltChainedException {
        TokenNode tk = dg.getTokenNode(index1);
        Set<DependencyNode> heads = null;
        if (tk != null) {
            heads = tk.getHeads();
            for (DependencyNode head : heads) {
                if (head.getIndex() != index2) continue;
                return true;
            }
        }
        if ((tk = dg.getTokenNode(index2)) != null) {
            heads = tk.getHeads();
            for (DependencyNode head : heads) {
                if (head.getIndex() != index1) continue;
                return true;
            }
        }
        return false;
    }

    private void labeledUndirectedGraphToDepTree(DependencyStructure graph) throws MaltChainedException {
        SortedSet<Edge> edges = graph.getEdges();
        for (Edge edge : edges) {
            Set<String> names = graph.getSymbolTables().getSymbolTableNames();
            for (String name : names) {
                if (name.compareTo("DEPREL") != 0) continue;
                String label = edge.getLabelSymbol(graph.getSymbolTables().getSymbolTable(name));
                if (label.charAt(label.length() - 1) == 'L') {
                    ((GraphEdge)edge).changeSense(edge.getTarget(), edge.getSource(), 1);
                }
                label = label.substring(0, label.length() - 1);
                edge.addLabel(graph.getSymbolTables().getSymbolTable(name), label);
            }
        }
    }

    private Edge getEdgeGraph(DependencyStructure dg, int index1, int index2) throws MaltChainedException {
        SortedSet<Edge> arcos = dg.getEdges();
        for (Edge arco : arcos) {
            if (arco.getSource().getIndex() == index1 && arco.getTarget().getIndex() == index2) {
                return arco;
            }
            if (arco.getSource().getIndex() != index2 || arco.getTarget().getIndex() != index1) continue;
            return arco;
        }
        return null;
    }

    private void solveDoubleHeadProblem(DependencyStructure graph) throws MaltChainedException {
        SortedSet<Integer> nodos = graph.getTokenIndices();
        block0: for (Integer nodo : nodos) {
            if (graph.getTokenNode(nodo).getHeads().size() <= 1) continue;
            Set<DependencyNode> heads = graph.getTokenNode(nodo).getHeads();
            for (DependencyNode head : heads) {
                Set<DependencyNode> headshead;
                Iterator<DependencyNode> it;
                DependencyNode headhead;
                if (head.isRoot() || head.getHeads().size() != 1 || !(headhead = (it = (headshead = head.getHeads()).iterator()).next()).isRoot()) continue;
                GraphEdge a = (GraphEdge)this.getEdgeGraph(graph, head.getIndex(), nodo);
                a.changeSense(a.getTarget(), a.getSource(), 1);
                graph.removeDependencyEdge(0, head.getIndex());
                continue block0;
            }
        }
    }

    private void solveDoubleHeadProblemAgain(DependencyStructure graph) throws MaltChainedException {
        SortedSet<Integer> nodos = graph.getTokenIndices();
        for (Integer nodo : nodos) {
            GraphEdge a;
            int destino;
            int origen;
            if (graph.getTokenNode(nodo).getHeads().size() <= 1) continue;
            Set<DependencyNode> heads = graph.getTokenNode(nodo).getHeads();
            Iterator<DependencyNode> it = heads.iterator();
            DependencyNode head1 = it.next();
            DependencyNode head2 = it.next();
            Stack<Integer> pilaHead1 = new Stack<Integer>();
            pilaHead1.push(new Integer(nodo));
            Stack<Integer> pilaHead2 = new Stack<Integer>();
            pilaHead2.push(new Integer(nodo));
            DependencyNode nextHead1 = head1;
            while (!nextHead1.getHead().isRoot()) {
                pilaHead1.push(new Integer(nextHead1.getIndex()));
                nextHead1 = nextHead1.getHead();
            }
            pilaHead1.push(new Integer(nextHead1.getIndex()));
            DependencyNode nextHead2 = head2;
            while (!nextHead2.getHead().isRoot()) {
                pilaHead2.push(new Integer(nextHead2.getIndex()));
                nextHead2 = nextHead2.getHead();
            }
            pilaHead2.push(new Integer(nextHead2.getIndex()));
            if (nextHead1.getIndex() < nextHead2.getIndex()) {
                graph.removeDependencyEdge(0, nextHead2.getIndex());
                while (((Integer)pilaHead2.peek()).intValue() != nodo.intValue()) {
                    origen = (Integer)pilaHead2.pop();
                    destino = (Integer)pilaHead2.peek();
                    a = (GraphEdge)this.getEdgeGraph(graph, origen, destino);
                    a.changeSense(a.getTarget(), a.getSource(), 1);
                }
                continue;
            }
            graph.removeDependencyEdge(0, nextHead1.getIndex());
            while (((Integer)pilaHead1.peek()).intValue() != nodo.intValue()) {
                origen = (Integer)pilaHead1.pop();
                destino = (Integer)pilaHead1.peek();
                a = (GraphEdge)this.getEdgeGraph(graph, origen, destino);
                a.changeSense(a.getTarget(), a.getSource(), 1);
            }
        }
    }

    private boolean holdSingleHead(DependencyStructure graph) throws MaltChainedException {
        SortedSet<Integer> unattach = graph.getTokenIndices();
        SortedSet<Integer> nodos = graph.getTokenIndices();
        for (Integer nodo : nodos) {
            if (!graph.getTokenNode(nodo).hasHead()) continue;
            unattach.remove(nodo);
        }
        if (unattach.isEmpty()) {
            return true;
        }
        for (Integer unodo : unattach) {
            SortedSet<DependencyNode> hijosIzq = graph.getTokenNode(unodo).getLeftDependents();
            SortedSet<DependencyNode> hijosDer = graph.getTokenNode(unodo).getRightDependents();
            for (DependencyNode hijo : hijosDer) {
                hijosIzq.add(hijo);
            }
            int destino = graph.getTokenNode(unodo).getClosestLeftDependent().getIndex();
            for (DependencyNode hijo : hijosIzq) {
                HashSet<Integer> conectedNodes = new HashSet<Integer>();
                this.conectedNodes(hijo.getIndex(), unodo, conectedNodes, graph);
                if (!conectedNodes.contains(0)) continue;
                destino = hijo.getIndex();
                break;
            }
            int origen = unodo;
            GraphEdge a = (GraphEdge)this.getEdgeGraph(graph, origen, destino);
            a.changeSense(a.getTarget(), a.getSource(), 1);
        }
        unattach = graph.getTokenIndices();
        nodos = graph.getTokenIndices();
        for (Integer nodo : nodos) {
            if (!graph.getTokenNode(nodo).hasHead()) continue;
            unattach.remove(nodo);
        }
        if (unattach.isEmpty()) {
            return true;
        }
        return this.holdSingleHead(graph);
    }

    private void linkNoConectedComponent(DependencyStructure graph) throws MaltChainedException {
        SortedSet<Integer> nodos = graph.getTokenIndices();
        for (Integer nodo : nodos) {
            if (graph.getTokenNode(nodo).hasHead()) continue;
            HashSet<Integer> conectedNodes = new HashSet<Integer>();
            this.conectedNodes(nodo, nodo, conectedNodes, graph);
            if (conectedNodes.contains(0)) continue;
            graph.addDependencyEdge(0, nodo);
        }
    }

    private void conectedNodes(int node, int nodeObj, Set<Integer> conectedNodes, DependencyStructure graph) throws MaltChainedException {
        SortedSet<Integer> allNodes = graph.getTokenIndices();
        allNodes.add(0);
        for (Integer nodo : allNodes) {
            if (!this.checkIfNodesAreRelated(graph, nodo, node) || conectedNodes.contains(nodo) || nodo == nodeObj) continue;
            conectedNodes.add(nodo);
            this.conectedNodes(nodo, nodeObj, conectedNodes, graph);
        }
    }
}

