/*
 * Decompiled with CFR 0.152.
 */
package tsg.fragStats;

import java.io.File;
import java.util.ArrayList;
import java.util.HashSet;
import java.util.Scanner;
import tsg.Label;
import tsg.TSNodeLabel;
import tsg.corpora.Wsj;
import util.FileUtil;

public class FragmentFinder {
    public static void findInTUT() throws Exception {
        File treebankFile = new File("/scratch/fsangati/CORPUS/Evalita09/Treebanks/Constituency/TUTinPENN-train.readable.notraces.quotesFixed.noSemTags.penn");
        ArrayList<TSNodeLabel> treebank = TSNodeLabel.getTreebank(treebankFile, "UTF-8", Integer.MAX_VALUE);
        TSNodeLabel target = new TSNodeLabel("(VMA~RE mette)");
        FragmentFinder.findInTreebankAndPrint(treebank, target, 100);
    }

    public static void findInWSJ(TSNodeLabel target) throws Exception {
        File treebankFile = new File(String.valueOf(Wsj.WsjOriginalCleanedTopSemTagsOff) + "wsj-02-21.mrg");
        ArrayList<TSNodeLabel> treebank = TSNodeLabel.getTreebank(treebankFile);
        FragmentFinder.findInTreebankAndPrint(treebank, target, Integer.MAX_VALUE);
    }

    public static void findInTreebankAndPrint(ArrayList<TSNodeLabel> treebank, TSNodeLabel target, int hits) {
        int count = 0;
        for (TSNodeLabel t : treebank) {
            if (!t.containsRecursive(target)) continue;
            System.out.println(t);
            if (++count == hits) break;
        }
    }

    public static ArrayList<TSNodeLabel> findInTreebank(ArrayList<TSNodeLabel> treebank, TSNodeLabel target) {
        ArrayList<TSNodeLabel> result = new ArrayList<TSNodeLabel>();
        for (TSNodeLabel t : treebank) {
            if (!t.containsRecursive(target)) continue;
            result.add(t);
        }
        return result;
    }

    public static void findYieldInTreebankAndPrint(ArrayList<TSNodeLabel> treebank, HashSet<Label> labs) {
        for (TSNodeLabel t : treebank) {
            ArrayList<Label> terms = t.collectLexicalLabels();
            if (!terms.containsAll(labs)) continue;
            System.out.println(t);
        }
    }

    public static ArrayList<TSNodeLabel> findAdjacentLexInTreebank(ArrayList<TSNodeLabel> treebank, String words) {
        ArrayList<TSNodeLabel> result = new ArrayList<TSNodeLabel>();
        words = " " + words + " ";
        for (TSNodeLabel t : treebank) {
            String lex = " " + t.toFlatSentence() + " ";
            if (!lex.contains(words)) continue;
            result.add(t);
        }
        return result;
    }

    public static void findShortestInTreebankAndPrint(ArrayList<TSNodeLabel> treebank, TSNodeLabel target) {
        int min = Integer.MAX_VALUE;
        TSNodeLabel result = null;
        for (TSNodeLabel t : treebank) {
            int length;
            if (!t.containsRecursive(target) || (length = t.countLexicalNodes()) >= min) continue;
            min = length;
            result = t;
        }
        if (result != null) {
            System.out.println(result);
        }
    }

    public static void findInFragment(TSNodeLabel target) throws Exception {
        String dir = "/scratch/fsangati/RESULTS/TSG/TSGkernels/Wsj/KenelFragments/SemTagOff_Top/all/";
        File fragmentsFile = new File(String.valueOf(dir) + "fragments_MUB_freq_all.txt");
        Scanner scan = FileUtil.getScanner(fragmentsFile);
        while (scan.hasNextLine()) {
            String fragmentString;
            TSNodeLabel fragment;
            String line = scan.nextLine();
            if (line.equals("") || !(fragment = new TSNodeLabel(fragmentString = line.split("\t")[0], false)).containsRecursive(target)) continue;
            System.out.println(line);
        }
    }

    public static void findPartialFragment(int index, String containsWord) throws Exception {
        File treebankFile = new File(String.valueOf(Wsj.WsjOriginalCleanedTop) + "wsj-02-21.mrg");
        File partialFragmentFile = new File("/scratch/fsangati/RESULTS/TSG/TSGkernels/Wsj/KenelFragments/SemTagOn/subBranch/20/correct/fragments_subBranch_MUB_freq_20_sorted_" + containsWord + "_correctCount.txt");
        ArrayList<TSNodeLabel> treebank = TSNodeLabel.getTreebank(treebankFile);
        TSNodeLabel tree = treebank.get(index);
        System.out.println(tree + "\n");
        Scanner scan = FileUtil.getScanner(partialFragmentFile);
        while (scan.hasNextLine()) {
            String[] fragmentFreq;
            String fragmentString;
            TSNodeLabel fragment;
            String line = scan.nextLine();
            if (line.equals("") || !tree.containsRecursivePartialFragment(fragment = new TSNodeLabel(fragmentString = (fragmentFreq = line.split("\t"))[0], false))) continue;
            System.out.println(line);
        }
    }

    public static void main(String[] args) throws Exception {
        File treebankFile = new File(String.valueOf(Wsj.WsjOriginalCleanedTopSemTagsOff) + "wsj-02-21.mrg");
        ArrayList<TSNodeLabel> treebank = TSNodeLabel.getTreebank(treebankFile);
        FragmentFinder.findInTreebankAndPrint(treebank, new TSNodeLabel("(NP NNP NN NNS , NP ,)", false), Integer.MAX_VALUE);
    }
}

