import numpy as np
import os
import cv2


# ../LipData/GRID/faces/s1/swaizn/1.jpg
def video_normal(video_path, mean_file, std_file):
    frames = []
    sum_frames = 0.
    sum_frames_square = 0.
    nframe = 0
    scale = 1e5
    for root, dirs, files in os.walk(video_path, topdown=False):
        for name in files:
            path = os.path.join(root, name)
            if name.endswith('.jpg'):
                img = cv2.imread(path, 0)
                #frames.append(img)
                img = np.array(img, dtype=np.float64)
                #img = sum(img) / (img.shape[0] * img.shape[1])
                sum_frames += img / scale
                sum_frames_square += img ** 2 / scale
                nframe += 1
    
    #frames = np.vstack(frames)
    #video_mean = np.mean(frames, axis=0)
    #video_std = np.std(frames, axis=0)
    
    video_mean = sum_frames / nframe * scale
    video_var = (sum_frames_square / nframe) * scale - video_mean ** 2
    video_std = np.sqrt(video_var)
    print(video_mean, video_std)
    #np.save(mean_file, video_mean)
    #np.save(std_file, video_std)
    print('Done!')

#print(np.load('video_mean.npy'), np.load('video_std.npy'))
video_normal('../../LipData/GRID/faces-small', 'video_mean.npy', 'video_std.npy')
