#!/bin/bash
#SBATCH --job-name=sni # create a short name for your job
#SBATCH -p llm
#SBATCH -N 1 # node count
#SBATCH --ntasks-per-node 1 # number of tasks to run per node
#SBATCH --cpus-per-task 32 # cpu-cores per task (>1 if multi-threaded tasks),--cpus-per-task
#SBATCH --gpus-per-node 8 # total gpus for job

OUTPUT_PREFIX=pretrain_hyperlora

torchrun --nproc_per_node=8 pretraining.py \
    --seed 42 \
    --do_eval \
    --predict_with_generate \
    --bf16 \
    --n_demonstrations 5 \
    --dataset_name data/sni \
    --hypelora_name_or_path hf_models/hyperlora-t5-large \
    --hyper_model_name_or_path hf_models/t5-large \
    --model_name_or_path hf_models/t5-large \
    --lora_path SNI_LORA_PATH \
    --pretrain_checkpoint YOUR_PRETRAIN_CHECKPOINT_FILE \
    --per_device_train_batch_size 3 \
    --per_device_eval_batch_size 16 \
    --gradient_accumulation_steps 4 \
    --learning_rate 2e-5 \
    --preprocessing_num_workers 16 \
    --generation_max_length 512 \
    --logging_strategy steps \
    --logging_steps 5 \
    --evaluation_strategy 'epoch' \
    --lr_scheduler_type 'cosine' \
    --num_train_epochs 8 \
    --warmup_ratio 0.05 \
    --max_seq_length 2048 \
    --max_demo_length 2048 \
    --max_answer_length 512 \
    --val_max_answer_length 512 \
    --save_total_limit 1 \
    --load_best_model_at_end \
    --metric_for_best_model rougeL \
    --greater_is_better True \
    --save_strategy 'epoch' \
    --input_column inputs \
    --output_column targets \
    --temperature 8 \
    --loss_beta 0.2 \
    --lora_rank 16 \
    --lora_alpha 8 \
    --lora_target_modules "['q', 'v']" \
    --lora_dropout 0.05 \
    --report_to wandb \
    --run_name ${OUTPUT_PREFIX} \
    --output_dir output/$OUTPUT_PREFIX