theory question_11_1
imports Main

begin

typedecl entity
typedecl event

consts
  ElectricalConductor :: "entity ⇒ bool"
  Outlet :: "entity ⇒ bool"
  Plugging :: "event ⇒ bool"
  Agent :: "event ⇒ entity ⇒ bool"
  Patient :: "event ⇒ entity ⇒ bool"
  Completing :: "event ⇒ bool"
  Circuit :: "entity ⇒ bool"
  Source :: "event ⇒ entity ⇒ bool"
  Complete :: "entity ⇒ bool"
  ElectricalCircuit :: "entity ⇒ bool"
  Provides :: "entity ⇒ entity ⇒ bool"
  Many :: "entity ⇒ bool"
  Appliances :: "entity ⇒ bool"
  OneOutlet :: "entity ⇒ bool"
  SameCircuit :: "entity ⇒ entity ⇒ bool"
  Dangerous :: "event ⇒ bool"
  Danger :: "event ⇒ bool"
  Safe :: "event ⇒ entity ⇒ bool"
  Electrocution :: "event ⇒ bool"
  Animal :: "entity ⇒ bool"
  PassingThrough :: "event ⇒ entity ⇒ bool"
  Harmful :: "event ⇒ bool"
  Near :: "event ⇒ event ⇒ bool"
  Electricity :: "entity ⇒ bool"

(* Explanation 1: Completing a circuit by plugging an electrical conductor into an outlet results in a source of electrical energy. *)
axiomatization where
  explanation_1: "∀x y z e. ElectricalConductor x ∧ Outlet y ∧ Plugging e ∧ Agent e x ∧ Patient e y ⟶ (∃e'. Completing e' ∧ Agent e' (Circuit y) ∧ Source e' (ElectricalEnergy ()))"

(* Explanation 2: A complete electrical circuit provides electrical energy. *)
axiomatization where
  explanation_2: "∀x. Complete x ∧ ElectricalCircuit x ⟶ Provides x (ElectricalEnergy ())"

(* Explanation 3: Electricity is electrical energy. *)
axiomatization where
  explanation_3: "∀x. Electricity x ⟷ ElectricalEnergy x"

(* Explanation 4: Plugging many appliances into one outlet, with the same electrical circuit, is dangerous. *)
axiomatization where
  explanation_4: "∀x y z. Many x ∧ Appliances y ∧ OneOutlet z ∧ SameCircuit z y ∧ Plugging e ∧ Agent e x ∧ Patient e y ⟶ Dangerous e"

(* Explanation 5: Danger implies the absence of safety. *)
axiomatization where
  explanation_5: "∀x. Danger x ⟶ (¬Safe x ())"

(* Explanation 6: Electrocution is a harmful result of electricity passing through an animal's body. *)
axiomatization where
  explanation_6: "∀x y. Electrocution x ∧ Animal y ∧ PassingThrough x y ⟶ Harmful x"

(* Explanation 7: Plugging many appliances into one outlet, with the same electrical circuit, brings one near a source of electrical energy, which is not safe around electricity. *)
axiomatization where
  explanation_7: "∀x y z. Many x ∧ Appliances y ∧ OneOutlet z ∧ SameCircuit z y ∧ Plugging e ∧ Agent e x ∧ Patient e y ⟶ (∃e'. Source e' (ElectricalEnergy ()) ∧ Near e e' ∧ ¬Safe e (ElectricalEnergy ()))"

theorem hypothesis:
  assumes asm: "Many x ∧ Appliances y ∧ OneOutlet z ∧ Plugging e ∧ Agent e x ∧ Patient e y ∧ Outlet y z"
  (* Hypothesis: Plugging many appliances into one outlet is not a way to stay safe around electricity. *)
  shows "¬Safe e  ElectricalEnergy    "
proof -
  from asm have danger: "Dangerous e" using explanation_4 by blast
  then have not_safe: "¬Safe e ()" using explanation_5 by blast
  then show "¬Safe e ElectricalEnergy" by simp
qed

end
