theory question_89_0
imports Main

begin

typedecl entity
typedecl event

consts
  Bicycling :: "event ⇒ bool"
  MountainBiking :: "event ⇒ bool"
  Forest :: "entity ⇒ bool"
  Woods :: "entity ⇒ bool"
  SeasonOfFall :: "entity ⇒ bool"
  Autumn :: "entity ⇒ bool"
  Person :: "entity ⇒ bool"
  Agent :: "event ⇒ entity ⇒ bool"
  Through :: "event ⇒ entity ⇒ bool"
  In :: "entity ⇒ entity ⇒ bool"
  Early :: "entity ⇒ bool"
  During :: "event ⇒ entity ⇒ bool"

(* Explanation 1: Mountain biking uses bikes and can thus be generically called bicycling.
   The woods is another word for forest. Autumn is another word for the season of fall. *)
axiomatization where
  explanation_1: "∀e. Bicycling e ↔ MountainBiking e"
   "∀y. Woods y ↔ Forest y"
   "∀z. Autumn z ↔ SeasonOfFall z"

theorem hypothesis:
  (* Premise: Mountain biking in a forest during the early fall. *)
  assumes asm: "Person x ∧ MountainBiking e ∧ Agent e x ∧ Forest y ∧ In x y ∧ SeasonOfFall z ∧ Early z ∧ During e z"
  (* Hypothesis: Bicycling through the woods in the Autumn. *)
  shows "∃x e. Person x ∧ Bicycling e ∧ Agent e x ∧ Woods y ∧ Through e y ∧ Autumn z ∧ In x z"
proof -
  from asm have "MountainBiking e" by blast
  then have "Bicycling e" using explanation_1 by blast
  from asm have "Forest y" by blast
  then have "Woods y" using explanation_1 by blast
  from asm have "SeasonOfFall z" by blast
  then have "Autumn z" using explanation_1 by blast
  from asm have "Person x" by blast
  from asm have "Agent e x" by blast
  from asm have "In x y" by blast
  show ?thesis using `Person x` `Bicycling e` `Agent e x` `Woods y` `Through e y` `Autumn z` `In x z` by blast
qed

end
