theory question_86_3
imports Main

begin

typedecl entity
typedecl event

consts
  Conversing :: "entity ⇒ event ⇒ bool"
  Talking :: "entity ⇒ event ⇒ bool"
  Woman :: "entity ⇒ bool"
  Table :: "entity ⇒ bool"
  At :: "entity ⇒ entity ⇒ bool"
  Drinks :: "entity ⇒ bool"
  With :: "entity ⇒ entity ⇒ bool"

(* Explanation: If there are women conversing, then there is a woman talking. *)
axiomatization where
  explanation: "∀x e. WomenConversing x e ⟶ (∃e'. Woman x ∧ Talking x e')"

theorem hypothesis:
  (* Premise: There are three woman conversing at a table with drinks. *)
  assumes asm: "Woman x ∧ Table e ∧ At x e ∧ Drinks e ∧ With x e ∧ WomenConversing x e"
  (* Hypothesis: Women are talking. *)
  shows "∃x. Woman x ∧ Talking x e"
proof -
  from asm have "WomenConversing x e" by blast
  then have "∃e'. Woman x ∧ Talking x e'" using explanation by blast
  then show ?thesis using asm by blast
qed

end
