theory question_5_0
imports Main

begin

typedecl entity
typedecl event

consts
  FootballPlayer :: "entity ⇒ bool"
  Field :: "entity ⇒ bool"
  Blue :: "entity ⇒ bool"
  Jerseys :: "entity ⇒ bool"
  Rams :: "entity ⇒ bool"
  White :: "entity ⇒ bool"
  Player :: "entity ⇒ bool"
  Running :: "event ⇒ bool"
  Football :: "entity ⇒ bool"
  With :: "event ⇒ entity ⇒ bool"
  Falling :: "event ⇒ bool"
  Attempt :: "event ⇒ event ⇒ bool"
  Tackling :: "event ⇒ bool"

(* Explanation: A football player is running with a football on a field. *)
axiomatization where
  explanation_1: "∀x y z e1. FootballPlayer x ∧ Blue y ∧ Jerseys y ∧ Rams z ∧ Field w ∧ Football v ∧ Running e1 ∧ Agent e1 x ∧ Patient e1 v ∧ With e1 y ⟶ Running e1"

theorem hypothesis:
  (* Premise: A football player in a blue 'Rams' jersey runs with a football on a field, as another player in a white jersey falls in an attempt to tackle him. *)
  assumes asm: "FootballPlayer x ∧ Blue y ∧ Jerseys y ∧ Rams z ∧ Field w ∧ Football v ∧ Running e1 ∧ Agent e1 x ∧ Patient e1 v ∧ With e1 y ∧ Player u ∧ White p ∧ Jerseys p ∧ Falling e2 ∧ Agent e2 u ∧ Attempt e2  Tackling e3  ∧ Agent e3 x ∧ Patient e3 u"
  (* Hypothesis: The football players are on a field. *)
  shows "∃x y. FootballPlayer x ∧ Field y ∧ On e ∧ Agent e x ∧ Patient e y"
proof -
  from asm have "FootballPlayer x" "Field w" by auto
  then have "∃x y. FootballPlayer x ∧ Field y ∧ On e ∧ Agent e x ∧ Patient e y" using that by blast
qed

end
