theory question_23_2
imports Main

begin

typedecl entity
typedecl event

consts
  Hurricane :: "entity ⇒ bool"
  Tornadoes :: "entity ⇒ bool"
  HighWindSpeeds :: "entity ⇒ bool"
  HighWinds :: "event ⇒ bool"
  Have :: "entity ⇒ event ⇒ bool"

(* Explanation 1: A hurricane is an entity that always has high wind speeds. *)
axiomatization where
  explanation_1: "∀x. Hurricane x ⟶ HighWindSpeeds x"

(* Explanation 2: A tornado is an entity that always has high wind speeds. *)
axiomatization where
  explanation_2: "∀x. Tornadoes x ⟶ HighWindSpeeds x"

(* Explanation 3: High wind speeds imply that there exists an event with high winds. *)
axiomatization where
  explanation_3: "∀x. HighWindSpeeds x ⟶ (∃e. HighWinds e)"

(* Explanation 4: An entity with high wind speeds has an event with high winds. *)
axiomatization where
  explanation_4: "∀x. HighWindSpeeds x ⟶ (∃e. HighWinds e ∧ Have x e)"

theorem hypothesis:
  assumes asm: "Hurricane x ∨ Tornadoes x"
  (* Hypothesis: Both hurricanes and tornadoes always have high winds. *)
  shows "∃e. HighWinds e ∧ Have x e"
proof -
  assume "Hurricane x"
  then have "HighWindSpeeds x" by (simp add: explanation_1)
  then obtain e where "HighWinds e ∧ Have x e" by (simp add: explanation_3)
  then show ?thesis by blast
next
  assume "Tornadoes x"
  then have "HighWindSpeeds x" by (simp add: explanation_2)
  then obtain e where "HighWinds e ∧ Have x e" by (simp add: explanation_3)
  then show ?thesis by blast
qed

end
