theory question_71_1

imports Main

begin

typedecl entity
typedecl event

consts
  Chloroplasts :: "entity ⇒ bool"
  Chlorophyll :: "entity ⇒ bool"
  Contains :: "entity ⇒ entity ⇒ bool"
  Animals :: "entity ⇒ bool"

(* Explanation 1: Chloroplasts contain the green pigment chlorophyll, and chlorophyll is only found in chloroplasts. *)
axiomatization where
  explanation_1: "∀x y. Chloroplasts x ∧ Chlorophyll y ⟷ Contains x y"

(* Explanation 2: Animals lack chloroplasts. *)
axiomatization where
  explanation_2: "∀x. Animals x ⟶ ¬Chloroplasts x"

theorem hypothesis:
  assumes asm: "Animals x"
  (* Hypothesis: Animals lack chlorophyll. *)
  shows "¬Chlorophyll x"
proof -
  from asm have "Animals x" by simp
  then have "¬Chloroplasts x" using explanation_2 by blast
  then have "¬∃y. Chloroplasts x ∧ Chlorophyll y ∧ Contains x y" using explanation_1 by blast
  then have "¬∃y. Chlorophyll y ∧ Contains x y" by simp
  then have "¬Chlorophyll x" by blast
  show ?thesis using asm by blast
qed

end
