import os
import torch
import random
import logging
import numpy as np
import torch.nn as nn

from datetime import timedelta
from time import time, strftime, localtime

class Logger(object):
    level_relations = {
        'debug':logging.DEBUG,
        'info':logging.INFO,
        'warning':logging.WARNING,
        'error':logging.ERROR,
        'crit':logging.CRITICAL
    }
    def __init__(self, filename, level='info', fmt='%(asctime)s: %(message)s'):
        self.logger = logging.getLogger(filename)
        self.logger.setLevel(self.level_relations.get(level))
        th = logging.FileHandler(filename=filename)
        th.setLevel(self.level_relations.get(level))
        self.logger.addHandler(th)

def secondsToStr(elapsed=None):
    if elapsed is None:
        return strftime("%Y-%m-%d %H:%M:%S", localtime())
    else:
        return str(timedelta(seconds=elapsed))

def log_running_time(start, message):
    end = time()
    elapsed = end-start
    print("Training Time={}, {}".format(secondsToStr(elapsed), message))

def ensure_dir(path):
    if not os.path.exists(path):
        os.makedirs(path)

def setup_seed(seed):
    np.random.seed(seed)
    random.seed(seed)
    torch.manual_seed(seed) #cpu
    torch.cuda.manual_seed_all(seed) 
    torch.backends.cudnn.deterministic = True 
    torch.backends.cudnn.benchmark = True 

def get_desc_from_result(result):
    desc = ""
    for key, value in result.items():
        if "main" not in key and "loss" not in key:
            desc += "{}={:.4f} ".format(key, value)
    return desc

def get_log_from_result(result):
    desc = ""
    for key in result:
        if key not in ["main", "eval_loss"]:
            desc += "\t{:.4f}".format(result[key])
    return desc
