import os
import myutils


for dataset in myutils.relTreebanks:
    bestOld = dataset + '.' + myutils.getBestUU(dataset, True)
    print(bestOld)

    oldModel = 'models/' + bestOld
    newModel = 'models/uuparser.test.' + dataset

    # Old:
    test = '../newsplits-v2.7/' + dataset + '/test.conllu'
    cmd = 'python3 uuparser/parser.py --predict --modeldir '
    cmd += oldModel.replace('uuparser/', '') + ' --testfile '
    cmd += test + ' --outdir ../preds/test.old.' + dataset + '/'
    cmd += ' --graph-based' # hardCoded?!
    print(cmd)

    # New:
    test = '../newsplits-v2.7/' + dataset + '/test.conllu'
    cmd = 'python3 uuparser/parser.py --predict --modeldir '
    cmd += newModel.replace('uuparser/', '') + ' --testfile '
    cmd += test + ' --outdir ../preds/test.new.' + dataset + '/'
    cmd += ' --graph-based' # hardCoded?!
    print(cmd)


