#!/usr/bin/env bash

OUT_DIR=results_review_bert


mkdir -p ${OUT_DIR}

args_add="--do_train --predict_type=dummy"
step="train"

nohup python3 run_dst_review.py \
        --model_type="bert" \
        --model_name_or_path="../pretrained_models/bert" \
        --load_ckpt="./results_bert/checkpoint-9464" \
        --do_lower_case \
        --learning_rate=5e-5 \
        --num_train_epochs=11 \
        --max_seq_length=256 \
        --per_gpu_train_batch_size=48 \
        --per_gpu_eval_batch_size=1 \
        --output_dir=${OUT_DIR} \
        --save_epochs=1 \
        --logging_steps=50 \
        --warmup_proportion=0.1 \
        --eval_all_checkpoints \
        --adam_epsilon=1e-6 \
        --label_value_repetitions \
        --swap_utterances \
        --append_history \
        --use_history_labels \
        --delexicalize_sys_utts \
        --class_aux_feats_inform \
        --class_aux_feats_ds \
        ${args_add} \
        > ${OUT_DIR}/review.log 2>&1 &
