"""Randomly chosen test docs"""

import os
import json
from best import file_ids_e114


def make_split(ids, test_ratio=0.2, valid_ratio=0.2):
    import numpy as np
    rng = np.random.RandomState(42)
    rng.shuffle(ids)

    n_ids = len(ids)
    n_test = int(np.ceil(test_ratio * n_ids))
    n_valid = int(np.ceil(valid_ratio * n_ids))

    test_ids = ids[0:n_test]
    valid_ids = ids[n_test:n_test + n_valid]
    assert set.intersection(set(test_ids), set(valid_ids)) == set()

    return test_ids, valid_ids


cache_f = os.path.join("data", "test_ids.json")

try:
    with open(cache_f) as f:
        test_id_data = json.load(f)
        test_ids = test_id_data['test_ids']
        valid_ids = test_id_data['valid_ids']
except IOError:
    test_ids_nw, valid_ids_nw = make_split(file_ids_e114.nw_ids)
    test_ids_df, valid_ids_df = make_split(file_ids_e114.df_ids)
    test_ids = test_ids_nw + test_ids_df
    valid_ids = valid_ids_nw + valid_ids_df

    with open(cache_f, 'w') as f:
        test_id_data = {'test_ids': test_ids, 'valid_ids': valid_ids}
        json.dump(test_id_data, f, indent=4)
