/*
 * Decompiled with CFR 0.152.
 */
package simplenlg.aggregation;

import java.util.ArrayList;
import java.util.List;
import simplenlg.aggregation.AggregationRule;
import simplenlg.aggregation.BackwardConjunctionReduction;
import simplenlg.aggregation.ClauseCoordination;
import simplenlg.aggregation.ForwardConjunctionReduction;
import simplenlg.realiser.CoordinateSPhraseSpec;
import simplenlg.realiser.SPhraseSpec;

public class ClauseAggregator {
    private List<AggregationRule> _rules = new ArrayList<AggregationRule>();

    public static ClauseAggregator newInstance() {
        ClauseAggregator aggregator = new ClauseAggregator();
        aggregator.addRule(new ForwardConjunctionReduction());
        aggregator.addRule(new BackwardConjunctionReduction());
        aggregator.addRule(new ClauseCoordination());
        return aggregator;
    }

    public void addRule(AggregationRule rule) {
        this._rules.add(rule);
    }

    public List<AggregationRule> getRules() {
        return this._rules;
    }

    public SPhraseSpec apply(SPhraseSpec ... sentences) {
        SPhraseSpec result = null;
        if (sentences.length > 1 && !this._rules.isEmpty()) {
            for (AggregationRule rule : this._rules) {
                SPhraseSpec intermediateResult;
                if (result == null) {
                    result = rule.apply(sentences);
                    continue;
                }
                if (!(result instanceof CoordinateSPhraseSpec) || (intermediateResult = rule.apply((CoordinateSPhraseSpec)result)) == null || !(intermediateResult instanceof CoordinateSPhraseSpec)) continue;
                result = intermediateResult;
            }
        }
        return result;
    }

    public SPhraseSpec apply(List<SPhraseSpec> sentences) {
        return this.apply(sentences.toArray(new SPhraseSpec[sentences.size()]));
    }
}

