/*
 * Decompiled with CFR 0.152.
 */
package edu.stanford.nlp.parser.metrics;

import edu.stanford.nlp.parser.metrics.AbstractEval;
import edu.stanford.nlp.trees.Tree;
import java.io.PrintWriter;
import java.util.List;

public class BestOfTopKEval {
    private final AbstractEval comparisonEval;
    private final AbstractEval countingEval;

    public BestOfTopKEval(AbstractEval comparisonEval, AbstractEval countingEval) {
        this.comparisonEval = comparisonEval;
        this.countingEval = countingEval;
    }

    public void evaluate(List<Tree> guesses, Tree gold, PrintWriter pw) {
        double bestF1 = Double.NEGATIVE_INFINITY;
        Tree bestTree = null;
        for (Tree tree : guesses) {
            this.comparisonEval.evaluate(tree, gold, null);
            double f1 = this.comparisonEval.getLastF1();
            if (bestTree != null && !(f1 > bestF1)) continue;
            bestTree = tree;
            bestF1 = f1;
        }
        this.countingEval.evaluate(bestTree, gold, pw);
    }

    public void display(boolean verbose) {
        this.display(verbose, new PrintWriter(System.out, true));
    }

    public void display(boolean verbose, PrintWriter pw) {
        this.countingEval.display(verbose, pw);
    }
}

