/*
 * Decompiled with CFR 0.152.
 */
package jigsaw.util;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.Iterator;
import java.util.List;
import java.util.NoSuchElementException;

public class ConcatenationIterator<E>
implements Iterator<E> {
    Iterator<Iterator<E>> sourceIterators;
    Iterator<E> currentIterator;
    Iterator<E> lastIteratorToReturn;

    @Override
    public boolean hasNext() {
        return this.currentIterator.hasNext();
    }

    @Override
    public E next() {
        if (this.currentIterator.hasNext()) {
            E e = this.currentIterator.next();
            this.lastIteratorToReturn = this.currentIterator;
            this.advance();
            return e;
        }
        throw new NoSuchElementException();
    }

    private void advance() {
        while (!this.currentIterator.hasNext() && this.sourceIterators.hasNext()) {
            this.currentIterator = this.sourceIterators.next();
        }
    }

    @Override
    public void remove() {
        if (this.lastIteratorToReturn == null) {
            throw new IllegalStateException();
        }
        this.currentIterator.remove();
    }

    public ConcatenationIterator(Iterator<Iterator<E>> sourceIterators) {
        this.sourceIterators = sourceIterators;
        this.currentIterator = new ArrayList().iterator();
        this.lastIteratorToReturn = null;
        this.advance();
    }

    public ConcatenationIterator(Collection<Iterator<E>> iteratorCollection) {
        this(iteratorCollection.iterator());
    }

    public static void main(String[] args) {
        List list0 = Collections.emptyList();
        List<String> list1 = Arrays.asList("a b c d".split(" "));
        List<String> list2 = Arrays.asList("e f".split(" "));
        ArrayList<Iterator<Iterator<String>>> iterators = new ArrayList<Iterator<Iterator<String>>>();
        iterators.add(list1.iterator());
        iterators.add(list0.iterator());
        iterators.add(list2.iterator());
        iterators.add(list0.iterator());
        ConcatenationIterator iterator = new ConcatenationIterator(iterators);
        while (iterator.hasNext()) {
            System.out.println((String)iterator.next());
        }
    }
}

