/*
 * Decompiled with CFR 0.152.
 */
package jigsaw.syntax;

import java.util.BitSet;
import java.util.Stack;
import jigsaw.syntax.Grammar;
import jigsaw.syntax.RecChart;
import jigsaw.syntax.Rule;

public class BitRecChart
implements RecChart {
    private BitSet _bc1 = null;
    private BitSet _bc2 = null;
    private int _pagesize = -1;
    private int _size = -1;
    private BitSet[] _chainvec = null;
    private Grammar _g = null;
    private int _maxs = -1;
    private short _maxpos = 0;

    public BitRecChart() {
    }

    public BitRecChart(Grammar g, short maxpos) {
        this._g = g;
        this._maxpos = maxpos;
        this._maxs = this._g.nts().size() - 1;
        this._pagesize = this._maxpos * (this._maxpos + 1) / 2;
        this._size = this._pagesize * (this._maxs + 1);
        this._bc1 = new BitSet(this._size);
        this._bc2 = new BitSet(this._size);
        this._chainvec = this._g.chainvec();
    }

    public BitRecChart(short maxpos, int maxs) {
        this._maxpos = maxpos;
        this._maxs = maxs;
        int pagenum = this._maxs + 1;
        this._pagesize = this._maxpos * (maxpos + 1) / 2;
        this._size = this._pagesize * pagenum;
        this._bc1 = new BitSet(this._size);
        this._bc2 = new BitSet(this._size);
    }

    public BitSet chainvec(int nt) {
        return this._chainvec[nt];
    }

    @Override
    public void clear(short start, short end, int nt) {
        assert (start >= 0 && end <= this._maxpos && start < end && nt <= this._maxs);
        int pageidx = nt * this._pagesize;
        int offset1 = start * this._maxpos - start * (start + 1) / 2 + end - 1;
        int offset2 = end * (end - 1) / 2 + start;
        this._bc1.clear(pageidx + offset1);
        this._bc2.clear(pageidx + offset2);
    }

    @Override
    public void clearAll() {
        this._bc1.clear();
        this._bc2.clear();
    }

    @Override
    public boolean get(short start, short end, int s) {
        assert (start >= 0 && end <= this._maxpos && start < end && s <= this._maxs);
        int offset = end * (end - 1) / 2 + start;
        return this._bc2.get(s * this._pagesize + offset);
    }

    @Override
    public void set(short start, short end, int s) {
        assert (start >= 0 && end <= this._maxpos && start < end && s <= this._maxs);
        int pageidx = s * this._pagesize;
        int offset1 = start * this._maxpos - start * (start + 1) / 2 + end - 1;
        int offset2 = end * (end - 1) / 2 + start;
        this._bc1.set(pageidx + offset1);
        this._bc2.set(pageidx + offset2);
    }

    public void or(short start, short end, BitSet vec) {
        assert (start >= 0 && end <= this._maxpos && start < end && vec.size() == this._maxs + 1);
        int i = 0;
        while (i < vec.size()) {
            if (vec.get(i)) {
                this.set(start, end, i);
            }
            ++i;
        }
    }

    public BitSet getVectorByStart(int start, short length, int s) {
        assert (start >= 0 && start < this._maxpos && s <= this._maxs);
        int idx = s * this._pagesize + start * this._maxpos - start * (start - 1) / 2;
        return this._bc1.get(idx, idx + length);
    }

    public BitSet getVectorByEnd(int end, short length, int s) {
        assert (end > 0 && end <= this._maxpos && s <= this._maxs);
        int idx = s * this._pagesize + end * (end + 1) / 2;
        return this._bc2.get(idx - length, idx);
    }

    public BitRecChart filter() {
        BitRecChart newchart = new BitRecChart(this._g, this._maxpos);
        this.filterSubtree((short)0, this._maxpos, this._g.NT(this._g.Start()), newchart);
        return newchart;
    }

    private void filterSubtree(short start, short end, int nt, BitRecChart newchart) {
        Stack<int[]> stack = new Stack<int[]>();
        stack.push(new int[]{start, end, nt});
        while (!stack.empty()) {
            int A;
            short e;
            int[] item = (int[])stack.pop();
            short s = (short)item[0];
            if (newchart.get(s, e = (short)item[1], A = item[2])) continue;
            newchart.set(s, e, A);
            for (Rule r : this._g.chainrules(A)) {
                if (!this.get(s, e, r.rhs()[0]) || newchart.get(s, e, r.rhs()[0])) continue;
                stack.push(new int[]{s, e, r.rhs()[0]});
            }
            for (Rule r : this._g.birules(A)) {
                BitSet vec1 = this.getVectorByStart(s, (short)(e - s - 1), r.rhs()[0]);
                BitSet vec2 = this.getVectorByEnd(e, (short)(e - s - 1), r.rhs()[1]);
                vec1.and(vec2);
                int m = vec1.nextSetBit(0);
                while (m >= 0) {
                    if (!newchart.get(s, (short)(s + m + 1), r.rhs()[0])) {
                        stack.push(new int[]{s, s + m + 1, r.rhs()[0]});
                    }
                    if (!newchart.get((short)(s + m + 1), e, r.rhs()[1])) {
                        stack.push(new int[]{s + m + 1, e, r.rhs()[1]});
                    }
                    m = vec1.nextSetBit(m + 1);
                }
            }
        }
    }

    public double fillrate() {
        return (double)this._bc1.cardinality() / (double)this._size;
    }

    public Object clone() {
        BitRecChart copy = new BitRecChart();
        copy._bc1 = (BitSet)this._bc1.clone();
        copy._bc2 = (BitSet)this._bc2.clone();
        copy._g = this._g;
        copy._maxs = this._maxs;
        copy._maxpos = this._maxpos;
        copy._size = this._size;
        copy._pagesize = this._pagesize;
        copy._chainvec = this._chainvec;
        return copy;
    }

    public static void main(String[] args) {
    }

    @Override
    public int maxS() {
        return this._maxs;
    }

    @Override
    public int maxpos() {
        return this._maxpos;
    }

    public int pagesize() {
        return this._pagesize;
    }

    public int size() {
        return this._size;
    }

    public boolean recognized() {
        return this.get((short)0, this._maxpos, this._g.NT(this._g.Start()));
    }
}

