/*
 * Decompiled with CFR 0.152.
 */
package fig.prob;

import fig.prob.Distrib;
import fig.prob.SuffStats;
import java.util.Random;

public class Binomial
implements Distrib<Boolean> {
    private double prob;

    public Binomial(double prob) {
        this.prob = prob;
    }

    public static double logProb(double prob, boolean x) {
        return x ? Math.log(prob) : Math.log(1.0 - prob);
    }

    public double logProb(boolean x) {
        return Binomial.logProb(this.prob, x);
    }

    @Override
    public double logProbObject(Boolean x) {
        return this.logProb(x);
    }

    @Override
    public double logProb(SuffStats stats) {
        throw new RuntimeException("Not implemented");
    }

    public static boolean sample(Random random, double prob) {
        return random.nextDouble() < prob;
    }

    public boolean sample(Random random) {
        return Binomial.sample(random, this.prob);
    }

    @Override
    public Boolean sampleObject(Random random) {
        return this.sample(random);
    }

    @Override
    public double crossEntropy(Distrib<Boolean> _that) {
        Binomial that = (Binomial)_that;
        return this.prob * Math.log(that.prob) + (1.0 - this.prob) * Math.log(1.0 - that.prob);
    }

    public double getProb() {
        return this.prob;
    }

    public String toString() {
        return String.format("Binomial(%.3f)", this.prob);
    }
}

