/*
 * Decompiled with CFR 0.152.
 */
package SyntaxUtils;

import SyntaxUtils.FeatureSet;
import fig.basic.LogInfo;
import java.io.BufferedReader;
import java.io.IOException;
import java.io.InputStreamReader;
import java.io.PipedInputStream;
import java.io.PipedOutputStream;
import java.io.PrintWriter;
import java.io.Writer;
import java.util.List;
import java.util.Map;
import org.ardverk.collection.Cursor;
import org.ardverk.collection.PatriciaTrie;
import org.ardverk.collection.StringKeyAnalyzer;

public class PerceptronClassifier
extends PatriciaTrie<String, Integer> {
    private static final long serialVersionUID = -8291040694796616684L;

    public PerceptronClassifier() {
        super(StringKeyAnalyzer.CHAR);
    }

    public PerceptronClassifier(PerceptronClassifier ano) {
        super(ano);
    }

    public int score(PatriciaTrie<String, Integer> feats) {
        int score = 0;
        for (Map.Entry e : feats.entrySet()) {
            Integer i = (Integer)this.get(e.getKey());
            score += i == null ? 0 : (Integer)e.getValue() * i;
        }
        return score;
    }

    public synchronized void plus(PatriciaTrie<String, Integer> another) {
        for (Map.Entry e : another.entrySet()) {
            Integer score = (Integer)this.get(e.getKey());
            score = score == null ? (Integer)e.getValue() : (Integer)e.getValue() + score;
            this.put((String)e.getKey(), score);
        }
    }

    public synchronized void minus(PatriciaTrie<String, Integer> another) {
        for (Map.Entry e : another.entrySet()) {
            Integer score = (Integer)this.get(e.getKey());
            score = score == null ? -((Integer)e.getValue()).intValue() : score - (Integer)e.getValue();
            this.put((String)e.getKey(), score);
        }
    }

    public int score(List<String> strFeats) {
        int score = 0;
        for (String f : strFeats) {
            Integer weight = (Integer)this.get(f);
            if (weight == null) continue;
            score += weight.intValue();
        }
        return score;
    }

    public void increaseOne(List<String> strFeats) {
        for (String f : strFeats) {
            Integer weight = (Integer)this.get(f);
            if (weight != null) {
                this.put(f, (Object)(weight + 1));
                continue;
            }
            this.put(f, (Object)1);
        }
    }

    public void decreaseOne(List<String> strFeats) {
        for (String f : strFeats) {
            Integer weight = (Integer)this.get(f);
            if (weight != null) {
                this.put(f, (Object)(weight - 1));
                continue;
            }
            this.put(f, (Object)-1);
        }
    }

    public void rebuild() {
        this.traverse((Cursor)new RebuildCursor());
    }

    public void dump(Writer w) throws IOException {
        this.rebuild();
        for (Map.Entry e : this.entrySet()) {
            w.write(e.getValue() + "\t" + (String)e.getKey() + "\n");
        }
        w.write("\n");
    }

    public void load(BufferedReader br) throws IOException {
        String s = null;
        s = br.readLine();
        while (s != null && s.trim().length() > 0) {
            String[] ss = s.split("\t", 2);
            int value = Integer.parseInt(ss[0].trim());
            String key = ss[1].trim();
            this.put(key, (Object)value);
            s = br.readLine();
        }
    }

    @Override
    public PerceptronClassifier clone() {
        PerceptronClassifier newOne = new PerceptronClassifier();
        for (Map.Entry e : this.entrySet()) {
            newOne.put((String)e.getKey(), (Integer)e.getValue());
        }
        return newOne;
    }

    public static void main(String[] args) throws IOException {
        PerceptronClassifier weight = new PerceptronClassifier();
        FeatureSet featSet = new FeatureSet();
        featSet.put("\u597d\u96e8\u77e5\u65f6\u8282");
        featSet.put("\u5f53\u6625\u4e43\u53d1\u751f");
        featSet.put("\u968f\u98ce\u6f5c\u5165\u591c");
        featSet.put("\u6da6\u7269\u7ec6\u65e0\u58f0");
        featSet.put("\u6da6\u7269\u7ec6\u65e0\u58f0");
        LogInfo.logs(featSet);
        LogInfo.logs(weight);
        LogInfo.logs(weight.score(featSet));
        weight.plus(featSet);
        LogInfo.logs(weight);
        LogInfo.logs(weight.score(featSet));
        weight.put("\u6da6\u7269\u7ec6\u65e0\u58f0", (Object)1);
        LogInfo.logs(weight);
        LogInfo.logs(weight.score(featSet));
        PatriciaTrie<String, Integer> feat = new PatriciaTrie<String, Integer>(StringKeyAnalyzer.CHAR);
        feat.put((Object)"\u62bd\u70df", (Object)1);
        feat.put((Object)"\u62bd\u70df", (Object)1);
        feat.put((Object)"\u559d\u9152", (Object)1);
        feat.put((Object)"\u70eb\u5934", (Object)1);
        PerceptronClassifier feat2 = new PerceptronClassifier();
        feat2.put("\u6d17\u8863", (Object)1);
        feat2.put("\u505a\u996d", (Object)1);
        PatriciaTrie<String, Integer> feat3 = new PatriciaTrie<String, Integer>(StringKeyAnalyzer.CHAR);
        feat3.put((Object)"\u505a\u996d", (Object)1);
        feat3.put((Object)"\u62bd\u70df", (Object)1);
        feat3.put((Object)"\u70eb\u5934", (Object)1);
        feat3.put((Object)"\u8def\u75f4", (Object)1);
        System.out.println("none:" + weight.score(feat2));
        weight.plus(feat2);
        System.out.println("after pending 2 score 1: " + weight.score(feat));
        System.out.println("after pending 2 score 2: " + weight.score(feat2));
        System.out.println("after pending 2 score 3: " + weight.score(feat3));
        weight.minus(feat);
        System.out.println("after substracting 1 score 3: " + weight.score(feat3));
        weight.plus(feat3);
        System.out.println(weight);
        weight.rebuild();
        System.out.println(weight);
        PipedOutputStream os = new PipedOutputStream();
        PipedInputStream pi = new PipedInputStream(os);
        PrintWriter pw = new PrintWriter(os);
        weight.dump(pw);
        pw.println();
        pw.println("hahaha");
        pw.close();
        BufferedReader bt = new BufferedReader(new InputStreamReader(pi));
        PerceptronClassifier another = new PerceptronClassifier();
        another.load(bt);
        bt.close();
        System.out.println(another);
        os.close();
        pi.close();
    }

    private class RebuildCursor
    implements Cursor<String, Integer> {
        private RebuildCursor() {
        }

        @Override
        public Cursor.Decision select(Map.Entry<? extends String, ? extends Integer> arg0) {
            return arg0.getValue() == 0 ? Cursor.Decision.REMOVE : Cursor.Decision.CONTINUE;
        }
    }
}

