/*
 * Decompiled with CFR 0.152.
 */
package LinguaView.syntax;

import LinguaView.TreePanel;
import LinguaView.syntax.DepTree;
import LinguaView.syntax.Edge;
import LinguaView.syntax.Token;
import java.awt.BasicStroke;
import java.awt.Color;
import java.awt.Graphics;
import java.awt.Graphics2D;
import java.awt.Point;
import java.awt.RenderingHints;
import java.awt.geom.GeneralPath;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Comparator;
import java.util.HashMap;
import java.util.Map;
import java.util.Set;

public class DepTreePanel
extends TreePanel<DepTree> {
    int[] tokenXLeftArray;
    int[] tokenXMiddleArray;
    int[] tokenLengthsArray;
    int[] edgeStartArray;
    int[] edgeEndArray;
    int[] edgeYArray;
    int[] edgeLevel;
    int[] STipsLevel;
    int[] ETipsLevel;
    int[] tokTipsNumber;
    Map<Integer, ArrayList<Integer>> TELeftPairs = new HashMap<Integer, ArrayList<Integer>>();
    Map<Integer, ArrayList<Integer>> TERightPairs = new HashMap<Integer, ArrayList<Integer>>();
    Map<Integer, ArrayList<Integer>> NestedChart = new HashMap<Integer, ArrayList<Integer>>();
    Map<Integer, ArrayList<Integer>> CrossedChart = new HashMap<Integer, ArrayList<Integer>>();
    Edge[] SpanSortedEdges;
    int[] SpanSortedIndexes;
    int tokenBaseline;
    int edgeBaseline;
    int edgeTipMargin = this.fontSize / 3;
    int edgeSpanMargin = this.fontSize * 2;
    int TEMargin = this.fontSize / 3;
    int propertyMargin = this.fontSize / 3;
    int labelMargin = this.fontSize / 3;

    @Override
    public void init() {
        this.wordSpace = this.fontSize;
        this.loadFont();
        this.loadSentence();
        this.setPreferredSize(this.area);
        this.setSize(this.area);
        this.revalidate();
        this.repaint();
    }

    @Override
    public void render(Graphics2D g2) {
        g2.setFont(this.font);
        g2.setColor(Color.BLACK);
        g2.setStroke(new BasicStroke());
        DepTree dep = this.getSentence(this.sentenceNumber);
        int i = 0;
        while (i < dep.tokens.size()) {
            Token curTok = dep.hasRoot && i == dep.tokens.size() - 1 ? dep.tokens.get(-1) : dep.tokens.get(i);
            if (curTok != null) {
                int plen = this.metrics.stringWidth(String.valueOf(curTok.getID()));
                int pXLeft = this.tokenXMiddleArray[i] - plen / 2;
                g2.drawString(String.valueOf(curTok.getID()), pXLeft, this.tokenBaseline);
                plen = this.metrics.stringWidth(curTok.gethead());
                pXLeft = this.tokenXMiddleArray[i] - plen / 2;
                g2.drawString(curTok.gethead(), pXLeft, this.tokenBaseline + this.propertyMargin + this.fontHight);
                int plevel = 2;
                g2.setColor(Color.GRAY);
                Set<String> pl = curTok.getPropertyList();
                for (String pn : pl) {
                    String p = curTok.getProperty(pn);
                    plen = this.metrics.stringWidth(p);
                    pXLeft = this.tokenXMiddleArray[i] - plen / 2;
                    g2.drawString(p, pXLeft, this.tokenBaseline + plevel * (this.propertyMargin + this.fontHight));
                    ++plevel;
                }
                g2.setColor(Color.BLACK);
            }
            ++i;
        }
        i = 0;
        while (i < dep.edges.size()) {
            Point p1 = new Point(this.edgeStartArray[i], this.edgeBaseline);
            Point p2 = new Point(this.edgeStartArray[i], this.edgeYArray[i]);
            Point p3 = new Point(this.edgeEndArray[i], this.edgeYArray[i]);
            Point p4 = new Point(this.edgeEndArray[i], this.edgeBaseline);
            this.createCurveArrow(p1, p2, p3, p4, g2);
            String label = dep.edges.get(i).getLabel();
            if (!label.trim().equals("_")) {
                int labelX = (this.edgeStartArray[i] + this.edgeEndArray[i]) / 2 - this.metrics.stringWidth(label) / 2;
                int labelY = this.edgeYArray[i] - this.labelMargin;
                g2.drawString(label, labelX, labelY);
            }
            ++i;
        }
    }

    private void createCurveArrow(Point p1, Point p2, Point p3, Point p4, Graphics2D g2) {
        GeneralPath shape = new GeneralPath();
        shape.moveTo(p1.x, p1.y);
        shape.curveTo(p2.x, p2.y, p2.x, p2.y, p2.x + (p3.x - p2.x) / 2, p2.y);
        shape.curveTo(p3.x, p3.y, p3.x, p3.y, p4.x, p4.y);
        shape.moveTo(p3.x, p3.y);
        shape.closePath();
        g2.draw(shape);
        int arrowSize = g2.getFont().getSize() / 5;
        int[] arrowX = new int[4];
        int[] arrowY = new int[4];
        arrowX[0] = p4.x;
        arrowX[1] = p4.x + arrowSize;
        arrowX[2] = p4.x;
        arrowX[3] = p4.x - arrowSize;
        arrowY[0] = p4.y;
        arrowY[1] = arrowY[0] - 2 * arrowSize;
        arrowY[2] = arrowY[0] - arrowSize;
        arrowY[3] = arrowY[0] - 2 * arrowSize;
        g2.fillPolygon(arrowX, arrowY, 4);
    }

    @Override
    protected void paintComponent(Graphics g) {
        super.paintComponent(g);
        Graphics2D g2 = (Graphics2D)g;
        g2.setRenderingHint(RenderingHints.KEY_ANTIALIASING, RenderingHints.VALUE_ANTIALIAS_ON);
        this.render(g2);
    }

    public void setSentenceNumber(int sn) {
        this.sentenceNumber = sn;
    }

    @Override
    public void loadSentence() {
        boolean dir;
        DepTree dep = this.getSentence(this.sentenceNumber);
        this.tokenXLeftArray = new int[dep.tokens.size()];
        this.tokenXMiddleArray = new int[dep.tokens.size()];
        this.tokenLengthsArray = new int[dep.tokens.size()];
        int i = 0;
        while (i < dep.tokens.size()) {
            this.tokenXLeftArray[i] = -1;
            ++i;
        }
        int currentXLeft = this.leftMargin;
        int i2 = 0;
        while (i2 < dep.tokens.size()) {
            Token token;
            if (dep.hasRoot && i2 == dep.tokens.size() - 1) break;
            if (dep.hasRoot && i2 == 0) {
                i2 = dep.tokens.size() - 1;
                Token rootToken = dep.tokens.get(-1);
                this.tokenXLeftArray[i2] = currentXLeft;
                this.tokenLengthsArray[i2] = this.metrics.stringWidth(this.getLongestProperty(rootToken));
                this.tokenXMiddleArray[i2] = currentXLeft + this.tokenLengthsArray[i2] / 2;
                currentXLeft = this.tokenXLeftArray[i2] + this.tokenLengthsArray[i2] + this.wordSpace;
                i2 = 0;
            }
            if ((token = dep.tokens.get(i2)) != null) {
                this.tokenXLeftArray[i2] = currentXLeft;
                this.tokenLengthsArray[i2] = this.metrics.stringWidth(this.getLongestProperty(token));
                this.tokenXMiddleArray[i2] = currentXLeft + this.tokenLengthsArray[i2] / 2;
                currentXLeft = this.tokenXLeftArray[i2] + this.tokenLengthsArray[i2] + this.wordSpace;
            }
            ++i2;
        }
        this.SpanSortedEdges = new Edge[0];
        this.SpanSortedEdges = dep.edges.values().toArray(this.SpanSortedEdges);
        this.SpanSortedIndexes = new int[this.SpanSortedEdges.length];
        Arrays.sort(this.SpanSortedEdges, new EdgeSpanComparator());
        i2 = 0;
        while (i2 < this.SpanSortedEdges.length) {
            int j = 0;
            while (j < dep.edges.size()) {
                if (this.SpanSortedEdges[i2].equals(dep.edges.get(j))) {
                    this.SpanSortedIndexes[i2] = j;
                }
                ++j;
            }
            ++i2;
        }
        this.TELeftPairs.clear();
        this.TERightPairs.clear();
        this.NestedChart.clear();
        this.CrossedChart.clear();
        i2 = 0;
        while (i2 < dep.edges.size()) {
            Edge e = dep.edges.get(i2);
            if (e != null) {
                int lp = e.getSmallIndex();
                int rp = e.getLargeIndex();
                ArrayList<Integer> LArray = this.TELeftPairs.get(lp);
                if (LArray == null) {
                    LArray = new ArrayList();
                }
                LArray.add(i2);
                this.TELeftPairs.put(lp, LArray);
                ArrayList<Integer> RArray = this.TERightPairs.get(rp);
                if (RArray == null) {
                    RArray = new ArrayList();
                }
                RArray.add(i2);
                this.TERightPairs.put(rp, RArray);
            }
            ++i2;
        }
        i2 = 0;
        while (i2 < dep.edges.size()) {
            Edge e1 = dep.edges.get(i2);
            ArrayList<Integer> tNested = new ArrayList<Integer>();
            ArrayList<Integer> tCrossed = new ArrayList<Integer>();
            int j = 0;
            while (j < dep.edges.size()) {
                Edge e2;
                if (i2 != j && (e2 = dep.edges.get(j)) != null) {
                    if (Edge.isNested(e1, e2)) {
                        tNested.add(j);
                    }
                    if (Edge.isCross(e1, e2)) {
                        tCrossed.add(j);
                    }
                }
                ++j;
            }
            if (!tNested.isEmpty()) {
                this.NestedChart.put(i2, tNested);
            }
            if (!tCrossed.isEmpty()) {
                this.CrossedChart.put(i2, tCrossed);
            }
            ++i2;
        }
        this.edgeLevel = new int[dep.edges.size()];
        i2 = 0;
        while (i2 < dep.edges.size()) {
            this.edgeLevel[i2] = 1;
            ++i2;
        }
        i2 = 0;
        while (i2 < this.SpanSortedIndexes.length) {
            int index = this.SpanSortedIndexes[i2];
            ArrayList<Integer> NestedEdges = this.NestedChart.get(index);
            int maxNestedLevel = 0;
            if (NestedEdges != null) {
                for (int ne : NestedEdges) {
                    if (this.edgeLevel[ne] <= maxNestedLevel) continue;
                    maxNestedLevel = this.edgeLevel[ne];
                }
            }
            ArrayList<Integer> CrossedEdges = this.CrossedChart.get(index);
            int maxCrossedLevel = 0;
            if (CrossedEdges != null) {
                for (int ce : CrossedEdges) {
                    if (this.edgeLevel[ce] <= maxCrossedLevel) continue;
                    Edge e1 = dep.edges.get(index);
                    Edge e2 = dep.edges.get(ce);
                    if (e1.getSpanLength() < e2.getSpanLength()) {
                        maxCrossedLevel = this.edgeLevel[ce];
                        continue;
                    }
                    if (e1.getSpanLength() != e2.getSpanLength() || e1.getSmallIndex() <= e2.getSmallIndex()) continue;
                    maxCrossedLevel = this.edgeLevel[ce];
                }
            }
            this.edgeLevel[index] = maxNestedLevel > maxCrossedLevel ? maxNestedLevel + 1 : maxCrossedLevel + 1;
            ++i2;
        }
        this.STipsLevel = new int[dep.edges.size()];
        this.ETipsLevel = new int[dep.edges.size()];
        this.tokTipsNumber = new int[dep.tokens.size()];
        i2 = 0;
        while (i2 < dep.tokens.size()) {
            Token curTok = dep.hasRoot && i2 == dep.tokens.size() - 1 ? dep.tokens.get(-1) : dep.tokens.get(i2);
            if (curTok != null) {
                Integer[] LTipEdges = new Integer[]{};
                Integer[] RTipEdges = new Integer[]{};
                if (dep.hasRoot && i2 == dep.tokens.size() - 1) {
                    i2 = -1;
                }
                if (this.TELeftPairs.get(i2) != null) {
                    LTipEdges = this.TELeftPairs.get(i2).toArray(LTipEdges);
                    Arrays.sort(LTipEdges, new EdgeLevelComparator());
                }
                if (this.TERightPairs.get(i2) != null) {
                    RTipEdges = this.TERightPairs.get(i2).toArray(RTipEdges);
                    Arrays.sort(RTipEdges, new EdgeLevelComparator());
                }
                if (i2 == -1) {
                    this.tokTipsNumber[dep.tokens.size() - 1] = LTipEdges.length + RTipEdges.length;
                } else {
                    this.tokTipsNumber[i2] = LTipEdges.length + RTipEdges.length;
                }
                if (this.TELeftPairs.get(i2) != null || this.TERightPairs.get(i2) != null) {
                    int levelAssigned = 0;
                    int j = 0;
                    while (j < RTipEdges.length) {
                        dir = dep.edges.get(RTipEdges[j]).getDirection();
                        if (dir) {
                            this.ETipsLevel[RTipEdges[j].intValue()] = levelAssigned;
                        } else {
                            this.STipsLevel[RTipEdges[j].intValue()] = levelAssigned;
                        }
                        ++levelAssigned;
                        ++j;
                    }
                    j = LTipEdges.length - 1;
                    while (j >= 0) {
                        dir = dep.edges.get(LTipEdges[j]).getDirection();
                        if (dir) {
                            this.STipsLevel[LTipEdges[j].intValue()] = levelAssigned;
                        } else {
                            this.ETipsLevel[LTipEdges[j].intValue()] = levelAssigned;
                        }
                        ++levelAssigned;
                        --j;
                    }
                }
                if (i2 == -1) break;
            }
            ++i2;
        }
        i2 = 0;
        while (i2 < dep.tokens.size()) {
            if (this.tokTipsNumber[i2] * this.edgeTipMargin > this.tokenLengthsArray[i2]) {
                int incre = this.tokTipsNumber[i2] * this.edgeTipMargin - this.tokenLengthsArray[i2];
                int n = i2;
                this.tokenLengthsArray[n] = this.tokenLengthsArray[n] + incre;
                int n2 = i2;
                this.tokenXLeftArray[n2] = this.tokenXLeftArray[n2] + incre / 2;
                int n3 = i2;
                this.tokenXMiddleArray[n3] = this.tokenXMiddleArray[n3] + incre / 2;
                if (i2 + 1 < dep.tokens.size()) {
                    int j = i2 + 1;
                    while (j < dep.tokens.size()) {
                        if (!dep.hasRoot || j != dep.tokens.size() - 1) {
                            int n4 = j;
                            this.tokenXLeftArray[n4] = this.tokenXLeftArray[n4] + incre;
                            int n5 = j++;
                            this.tokenXMiddleArray[n5] = this.tokenXMiddleArray[n5] + incre;
                            continue;
                        }
                        break;
                    }
                } else if (dep.hasRoot) {
                    int j = 0;
                    while (j < dep.tokens.size() - 1) {
                        int n6 = j;
                        this.tokenXLeftArray[n6] = this.tokenXLeftArray[n6] + incre;
                        int n7 = j++;
                        this.tokenXMiddleArray[n7] = this.tokenXMiddleArray[n7] + incre;
                    }
                }
            }
            ++i2;
        }
        i2 = 0;
        while (i2 < dep.edges.size()) {
            Edge e = dep.edges.get(i2);
            int labelLength = this.metrics.stringWidth(e.getLabel());
            int lp = e.getSmallIndex();
            int rp = e.getLargeIndex();
            if (lp == -1) {
                lp = dep.tokens.size() - 1;
            } else if (rp == -1) {
                rp = dep.tokens.size() - 1;
            }
            int spanLength = this.tokenXLeftArray[rp] - this.tokenXLeftArray[lp] - this.tokenLengthsArray[lp];
            if (spanLength < labelLength) {
                int incre = labelLength - spanLength;
                int n = rp;
                this.tokenXLeftArray[n] = this.tokenXLeftArray[n] + incre;
                int n8 = rp;
                this.tokenXMiddleArray[n8] = this.tokenXMiddleArray[n8] + incre;
                if (rp + 1 < dep.tokens.size()) {
                    int j = rp + 1;
                    while (j < dep.tokens.size()) {
                        if (!dep.hasRoot || j != dep.tokens.size() - 1) {
                            int n9 = j;
                            this.tokenXLeftArray[n9] = this.tokenXLeftArray[n9] + incre;
                            int n10 = j++;
                            this.tokenXMiddleArray[n10] = this.tokenXMiddleArray[n10] + incre;
                            continue;
                        }
                        break;
                    }
                } else if (dep.hasRoot) {
                    int j = 0;
                    while (j < dep.tokens.size() - 1) {
                        int n11 = j;
                        this.tokenXLeftArray[n11] = this.tokenXLeftArray[n11] + incre;
                        int n12 = j++;
                        this.tokenXMiddleArray[n12] = this.tokenXMiddleArray[n12] + incre;
                    }
                }
            }
            ++i2;
        }
        this.edgeStartArray = new int[dep.edges.size()];
        this.edgeEndArray = new int[dep.edges.size()];
        this.edgeYArray = new int[dep.edges.size()];
        i2 = 0;
        while (i2 < dep.tokens.size()) {
            ArrayList<Integer> rightToks;
            ArrayList<Integer> leftToks = dep.hasRoot && i2 == dep.tokens.size() - 1 ? this.TELeftPairs.get(-1) : this.TELeftPairs.get(i2);
            if (leftToks != null) {
                int midPoint = this.tokTipsNumber[i2] / 2;
                for (int ei : leftToks) {
                    boolean dir2 = dep.edges.get(ei).getDirection();
                    if (dir2) {
                        this.edgeStartArray[ei] = this.tokenXMiddleArray[i2] + (this.STipsLevel[ei] - midPoint) * this.edgeTipMargin;
                        continue;
                    }
                    this.edgeEndArray[ei] = this.tokenXMiddleArray[i2] + (this.ETipsLevel[ei] - midPoint) * this.edgeTipMargin;
                }
            }
            if ((rightToks = dep.hasRoot && i2 == dep.tokens.size() - 1 ? this.TERightPairs.get(-1) : this.TERightPairs.get(i2)) != null) {
                int midPoint = this.tokTipsNumber[i2] / 2;
                for (int ei : rightToks) {
                    dir = dep.edges.get(ei).getDirection();
                    if (!dir) {
                        this.edgeStartArray[ei] = this.tokenXMiddleArray[i2] + (this.STipsLevel[ei] - midPoint) * this.edgeTipMargin;
                        continue;
                    }
                    this.edgeEndArray[ei] = this.tokenXMiddleArray[i2] + (this.ETipsLevel[ei] - midPoint) * this.edgeTipMargin;
                }
            }
            ++i2;
        }
        int maxLevel = 0;
        int i3 = 0;
        while (i3 < dep.edges.size()) {
            if (this.edgeLevel[i3] > maxLevel) {
                maxLevel = this.edgeLevel[i3];
            }
            ++i3;
        }
        this.edgeBaseline = (int)((double)this.topMargin + (double)maxLevel * this.levelSize);
        i3 = 0;
        while (i3 < dep.edges.size()) {
            this.edgeYArray[i3] = (int)((double)this.edgeBaseline - (double)this.edgeLevel[i3] * this.levelSize);
            ++i3;
        }
        this.tokenBaseline = this.edgeBaseline + this.TEMargin + this.fontHight;
        int maxPropertyListLength = 0;
        int i4 = 0;
        while (i4 < dep.tokens.size()) {
            if (dep.hasRoot && i4 == dep.tokens.size() - 1) {
                i4 = -1;
                Token curTok = dep.tokens.get(i4);
                int curPropertyListLength = curTok.getPropertyList().size();
                if (curPropertyListLength <= maxPropertyListLength) break;
                maxPropertyListLength = curPropertyListLength;
                break;
            }
            Token curTok = dep.tokens.get(i4);
            int curPropertyListLength = curTok.getPropertyList().size();
            if (curPropertyListLength > maxPropertyListLength) {
                maxPropertyListLength = curPropertyListLength;
            }
            ++i4;
        }
        this.area.height = this.tokenBaseline + (maxPropertyListLength + 1) * (this.propertyMargin + this.fontHight) + this.bottomMargin;
        this.area.width = dep.hasRoot ? this.tokenXLeftArray[this.tokenXLeftArray.length - 2] + this.tokenLengthsArray[this.tokenLengthsArray.length - 2] + this.rightMargin : this.tokenXLeftArray[this.tokenXLeftArray.length - 1] + this.tokenLengthsArray[this.tokenLengthsArray.length - 1] + this.rightMargin;
    }

    private String getLongestProperty(Token tok) {
        Set<String> pl = tok.getPropertyList();
        String res = String.valueOf(tok.getID());
        if (this.metrics.stringWidth(res) < this.metrics.stringWidth(tok.gethead())) {
            res = tok.gethead();
        }
        for (String pn : pl) {
            String p = tok.getProperty(pn);
            if (this.metrics.stringWidth(p) <= this.metrics.stringWidth(res)) continue;
            res = p;
        }
        return res;
    }

    public DepTree getSentence(int n) {
        return (DepTree)this.treebank.get(n);
    }

    class EdgeLevelComparator
    implements Comparator<Integer> {
        EdgeLevelComparator() {
        }

        @Override
        public int compare(Integer arg0, Integer arg1) {
            return DepTreePanel.this.edgeLevel[arg0] - DepTreePanel.this.edgeLevel[arg1];
        }
    }

    class EdgeSpanComparator
    implements Comparator<Edge> {
        EdgeSpanComparator() {
        }

        @Override
        public int compare(Edge arg0, Edge arg1) {
            return arg0.getSpanLength() - arg1.getSpanLength();
        }
    }
}

