/*
 * Decompiled with CFR 0.152.
 */
package LinguaView.syntax;

import LinguaView.syntax.Index;
import LinguaView.syntax.Tree;
import java.util.ArrayList;
import java.util.List;

public class ConstTree
extends Tree<String> {
    private String[] la;
    ConstTree parent;

    private ConstTree(String label) {
        super(label);
    }

    public ConstTree(String label, String[] la) {
        super(label);
        this.setLa(la);
    }

    public ConstTree(String label, List<Tree<String>> children) {
        super(label, children);
    }

    public ConstTree(String label, List<Tree<String>> children, String[] la) {
        super(label, children);
        this.setLa(la);
    }

    public String[] getLa() {
        return this.la;
    }

    public void setLa(String[] la) {
        this.la = la;
    }

    public List<ConstTree> getConstChildren() {
        List cl = super.getChildren();
        ArrayList<ConstTree> res = new ArrayList<ConstTree>();
        for (Tree c : cl) {
            res.add((ConstTree)c);
        }
        return res;
    }

    public List<ConstTree> constSubTreeList() {
        List cl = super.subTreeList();
        ArrayList<ConstTree> res = new ArrayList<ConstTree>();
        for (Tree c : cl) {
            res.add((ConstTree)c);
        }
        return res;
    }

    public static class ConstTreeIO {
        private ConstTreeIO() {
        }

        public static ConstTree ReadConstTree(String PennTree) {
            PennTree = PennTree.replaceAll("[\n\t\\ ]+", " ");
            if ((PennTree = PennTree.trim()).matches("^\\( *\\)$") || PennTree.equals("")) {
                ConstTree res = new ConstTree(null, null, null);
                return res;
            }
            PennTree = PennTree.startsWith("( ") ? PennTree.substring(PennTree.indexOf(40) + 1, PennTree.lastIndexOf(41)).trim() : PennTree.trim();
            String tag = PennTree.substring(PennTree.indexOf(40) + 1, PennTree.indexOf(32));
            String[] tags = tag.split("__");
            ConstTree res = new ConstTree(tags[0], new String[0]);
            if (tags.length > 1) {
                String[] la = new String[tags.length - 1];
                int i = 1;
                while (i < tags.length) {
                    la[i - 1] = tags[i].replace('^', '\u2191').replace('!', '\u2193').replace('@', '\u220a');
                    ++i;
                }
                res.setLa(la);
            }
            ArrayList L = new ArrayList();
            Index currentPos = new Index(ConstTreeIO.findNearestNonSpace(PennTree, PennTree.indexOf(32)));
            while (currentPos.value < PennTree.length()) {
                if (PennTree.charAt(currentPos.value) == ')') break;
                if (PennTree.charAt(currentPos.value) != ' ') {
                    ConstTree temp = ConstTreeIO.ReadConstTree(PennTree, currentPos);
                    L.add(temp);
                    temp.parent = res;
                    continue;
                }
                ++currentPos.value;
            }
            res.setChildren(L);
            return res;
        }

        private static ConstTree ReadConstTree(String PennTree, Index currentPos) {
            int i;
            boolean isLexical = false;
            int startpt = 0;
            int endpt = 0;
            currentPos.value = ConstTreeIO.findNearestNonSpace(PennTree, currentPos.value);
            if (PennTree.charAt(currentPos.value) == '(') {
                startpt = currentPos.value + 1;
                i = currentPos.value;
                while (i < PennTree.length()) {
                    if (PennTree.charAt(i) == ' ' && i > startpt) {
                        endpt = i;
                        break;
                    }
                    ++i;
                }
            } else {
                isLexical = true;
                startpt = currentPos.value;
                i = currentPos.value;
                while (i < PennTree.length()) {
                    if ((PennTree.charAt(i) == '(' || PennTree.charAt(i) == ')') && i > startpt) {
                        endpt = i;
                        break;
                    }
                    ++i;
                }
            }
            String tag = PennTree.substring(startpt, endpt);
            String[] tags = tag.split("__");
            ConstTree res = new ConstTree(tags[0], new String[0]);
            if (tags.length > 1) {
                String[] la = new String[tags.length - 1];
                int i2 = 1;
                while (i2 < tags.length) {
                    la[i2 - 1] = tags[i2].replace('^', '\u2191').replace('!', '\u2193').replace('@', '\u220a');
                    ++i2;
                }
                res.setLa(la);
            }
            ArrayList L = new ArrayList();
            currentPos.value = ConstTreeIO.findNearestNonSpace(PennTree, endpt);
            if (!isLexical) {
                while (currentPos.value < PennTree.length()) {
                    if (PennTree.charAt(currentPos.value) == ')') {
                        if (!res.isLeaf()) break;
                        ++currentPos.value;
                        currentPos.value = ConstTreeIO.findNearestNonSpace(PennTree, currentPos.value);
                        break;
                    }
                    ConstTree temp = ConstTreeIO.ReadConstTree(PennTree, currentPos);
                    L.add(temp);
                    temp.parent = res;
                }
            }
            res.setChildren(L);
            return res;
        }

        private static int findNearestNonSpace(String PennTree, int pos) {
            while (PennTree.charAt(pos) == ' ' && pos < PennTree.length()) {
                ++pos;
            }
            return pos;
        }
    }
}

