
///////////////////////////////////////////////////////////////////////////////
//                                                                           //
// This file is part of ModelBlocks. Copyright 2009, ModelBlocks developers. //
//                                                                           //
//    ModelBlocks is free software: you can redistribute it and/or modify    //
//    it under the terms of the GNU General Public License as published by   //
//    the Free Software Foundation, either version 3 of the License, or      //
//    (at your option) any later version.                                    //
//                                                                           //
//    ModelBlocks is distributed in the hope that it will be useful,         //
//    but WITHOUT ANY WARRANTY; without even the implied warranty of         //
//    MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the          //
//    GNU General Public License for more details.                           //
//                                                                           //
//    You should have received a copy of the GNU General Public License      //
//    along with ModelBlocks.  If not, see <http://www.gnu.org/licenses/>.   //
//                                                                           //
///////////////////////////////////////////////////////////////////////////////

#include "nl-cpt.h"

char psX[]   = "";
char psSpc[] = " ";

char psLBrace[]="{";
char psRBrace[]="}";
char psColon[]=":";

//// U: left or right indicator for grammar rule
DiscreteDomain<int> domU;
typedef DiscreteDomainRV<int,domU> U;
const U U_L ("l");
const U U_R ("r");
//const U U_BOT ("-");
const U U_TOP ("l");

//// D: center-embedding depth
DiscreteDomain<int> domD;
typedef DiscreteDomainRV<int,domD> D;
//const D D_BOT ("-");
const D D_TOP ("0");

typedef DelimitedJoint2DRV<psX,U,psSpc,D,psX> UD;
//const UD UD_BOT (U_BOT,D_BOT);
const UD UD_TOP (U_TOP,D_TOP);

//// B: boolean
DiscreteDomain<int> domB;
typedef DiscreteDomainRV<int,domB> B;
const B B_1 ("1");
const B B_0 ("0");

//// C: syntactic symbol
//DiscreteDomain<int> domC;
//typedef DiscreteDomainRV<int,domC> C;
DiscreteDomain<int> domC;
class C : public DiscreteDomainRV<int,domC> {
 private:
  static SimpleHash<C,B> hToTerm;
  void calcDetModels ( string s ) {
    if (!hToTerm.contains(*this)) {
      hToTerm.set(*this) = (('A'<=s[0] && s[0]<='Z') || s.find('_')!=string::npos) ? B_0 : B_1;
    }
  }
 public:
  C ( )                                      : DiscreteDomainRV<int,domC> ( )    { }
  C ( const DiscreteDomainRV<int,domC>& rv ) : DiscreteDomainRV<int,domC>(rv) { }
  C ( const char* ps )                       : DiscreteDomainRV<int,domC> ( ps ) { calcDetModels(ps); }
  //C ( string s ) : DiscreteDomainRV<int,domC> ( s )  { calcDetModels(s); }
  B getTerm ( ) const { return hToTerm.get(*this); }
  friend pair<StringInput,C*> operator>> ( StringInput si, C& c ) { return pair<StringInput,C*>(si,&c); }
  friend StringInput operator>> ( pair<StringInput,C*> si_c, const char* psD ) {
    if ( si_c.first == NULL ) return NULL;
    StringInput si=si_c.first>>(DiscreteDomainRV<int,domC>&)*si_c.second>>psD;
    si_c.second->calcDetModels(si_c.second->getString()); return si; }
};
SimpleHash<C,B> C::hToTerm;
const C C_BOT ("-");
const C C_TOP ("REST");

//// L: relation symbol
DiscreteDomain<int> domL;
typedef DiscreteDomainRV<int,domL> L;
const L L_BOT ("-");
const L L_TOP ("h");

//// E: headword/referent symbol
DiscreteDomain<int> domE;
typedef DiscreteDomainRV<int,domE> E;
const E E_BOT ("-");
const E E_TOP ("-");
//const E E_UNK ("unk");

//// CC: helper model -- child constituents
typedef DelimitedJoint2DRV<psX,C,psSpc,C,psX> CC;
//const CC CC_TOP (C_TOP,C_TOP);

//// LC: rel-annotated syntax
typedef DelimitedJoint2DRV<psX,L,psColon,C,psX> LC;
const LC LC_TOP (L_TOP,C_TOP);

//// LCLC: child rel-annotated syntax
typedef DelimitedJoint2DRV<psX,LC,psSpc,LC,psX> LCLC;

//// G: true grammar rule symbol
typedef DelimitedJoint3DRV<psX,L,psColon,C,psLBrace,E,psRBrace> LCE;
typedef DelimitedJoint2DRV<psX,UD,psSpc,LCE,psX> G;
const G G_TOP (UD_TOP,LCE(L_TOP,C_TOP,E_TOP));

/*
//// G: true grammar rule symbol
//typedef DelimitedJoint2DRV<psX,C,psLBrace,E,psRBrace> G;
class G : public DelimitedJoint3DRV<psX,UD,psSpc,C,psLBrace,E,psRBrace> {
 public:
  G ( )                       : DelimitedJoint3DRV<psX,UD,psSpc,C,psLBrace,E,psRBrace>()      { }
  G ( const UD& ud, const C& c, const E& e) : DelimitedJoint3DRV<psX,UD,psSpc,C,psLBrace,E,psRBrace>(ud,c,e) { }
  G ( const Gr& gr )          : DelimitedJoint3DRV<psX,UD,psSpc,C,psLBrace,E,psRBrace>(gr.first,gr.second.second,gr.second.third) { }
  //int toInt ( ) const { return this->first.toInt()*E::getDomain().getSize() + this->second.toInt(); }
};
//const G G_BOT (UD_BOT,C_BOT,E_BOT);
const G G_TOP (UD_TOP,C_TOP,E_TOP);

//// GG: pair of grammar rule symbols associated with rule expansion
typedef DelimitedJoint2DRV<psX,G,psSpc,G,psX> GG;
//const GG GG_BOT ( G_BOT, G_BOT );
*/

//// HW: real headwords vs. unk
DiscreteDomain<int> domHW;
typedef DiscreteDomainRV<int,domHW> HW;
const HW HW_UNK ("unk");


//// HW headword model
typedef CPT1DModel<HW,LogProb> HWModel;

//// M Syntax Model, LC LC given G=CE... STORED AS PROB, not LogProb
typedef CPT2DModel<LCLC,G,Prob> MModel;
//// L Semantics Model, E given L E... STORED AS PROB, not LogProb
typedef CPT3DModel<E,L,E,Prob> LModel;

//// Model of LC (prior)
typedef CPT1DModel<LC,LogProb> LCModel;
//// Model of G (prior)
typedef CPT1DModel<G,LogProb> GModel;

//// Model of Gr (prior incl. L)
//typedef CPT1DModel<Gr,LogProb> GrModel;
//// Model of G given G (unary branching expansion)
typedef CPT2DModel<G,G,LogProb> GuModel;



//// Model of GG given G (binary branching expansion)... STORED AS PROB, not LogProb
//typedef CPT2DModel<GG,G,Prob> GGModel;






//// H: pre-clustered word (array of letters, arranged last to first)...
//typedef StaticSafeArray<5,Lt> H;
DiscreteDomain<int> domainH;
class H : public DiscreteDomainRV<int,domainH>, public StaticSafeArray<5,Lt> {
 public:
  H ( ) { }
  H ( const char* ps ) : DiscreteDomainRV<int,domainH>(ps) {
    char psTemp[2]="-"; int n=strlen(ps);
    for(int i=0;i<5;i++) {
      psTemp[0]=(i<n)?ps[n-i-1]:'_';
      //cout<<"!!!!!!!!!!!!!!!!!!"<<psTemp<<endl;
      StaticSafeArray<5,Lt>::set(i)=Lt(psTemp);
    }
  }
  friend pair<StringInput,H*> operator>> ( const StringInput ps, H& rv ) { return pair<StringInput,H*>(ps,&rv); }
  friend StringInput operator>> ( pair<StringInput,H*> si_h, const char* psDlm ) {
    if(si_h.first==NULL)return si_h.first; String s; StringInput si=si_h.first>>s>>psDlm; *si_h.second=s.c_array(); return si; }
  bool   operator== ( const H& h ) const { return DiscreteDomainRV<int,domainH>::operator==(h); }
  size_t getHashKey ( )            const { return DiscreteDomainRV<int,domainH>::getHashKey();  }
};
const H H_UNK("unk");

typedef CPT2DModel<H,E,LogProb> HModel;
