from __future__ import print_function

import sys
from itertools import izip_longest
from codecs import open

if __name__ == '__main__':
    if len(sys.argv) < 3:
        print('Usage: python print_files_interleaved.py file_1 file_2')

    files = [open(filename, 'r', 'utf-8') for filename in sys.argv[1:]]
    for lines in izip_longest(*files, fillvalue='<>'):
        for line in lines:
            print(line.strip())
        print('-' * 42)

    for file in files:
        file.close()
        