/*
 * Decompiled with CFR 0.152.
 */
package babel.util.dict;

import babel.util.misc.FileList;
import babel.util.misc.RegExFileNameFilter;
import java.io.BufferedReader;
import java.io.BufferedWriter;
import java.io.FileInputStream;
import java.io.FileWriter;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.SequenceInputStream;
import java.util.Collection;
import java.util.HashMap;
import java.util.HashSet;
import java.util.LinkedList;
import java.util.Random;
import java.util.Set;

public class SimpleDictionary {
    protected static final String DEFAULT_ENCODING = "UTF-8";
    protected HashMap<String, HashSet<String>> m_map;
    protected Random m_rand = new Random(1L);
    protected String m_name;

    protected SimpleDictionary(String name) {
        this.m_map = new HashMap();
        this.m_name = name;
    }

    public SimpleDictionary(DictHalves dictFiles, String name) throws Exception {
        this(name);
        this.read(this.m_map, new InputStreamReader((InputStream)new FileInputStream(dictFiles.srcDictFile), DEFAULT_ENCODING), new InputStreamReader((InputStream)new FileInputStream(dictFiles.trgDictFile), DEFAULT_ENCODING));
    }

    public SimpleDictionary(String dictFile, String name) throws Exception {
        this(name);
        this.read(this.m_map, new InputStreamReader((InputStream)new FileInputStream(dictFile), DEFAULT_ENCODING));
    }

    public SimpleDictionary(String dictPath, String fileNameRegEx, String name) throws Exception {
        this(name);
        FileList list = new FileList(dictPath, new RegExFileNameFilter(fileNameRegEx));
        list.gather();
        this.read(this.m_map, new InputStreamReader((InputStream)new SequenceInputStream(list), DEFAULT_ENCODING));
    }

    public String getName() {
        return this.m_name;
    }

    public DictPair splitPercent(String nameDict, String nameRest, double part) throws Exception {
        if (part < 0.0 || part > 1.0) {
            throw new IllegalArgumentException();
        }
        return this.splitPart(nameDict, nameRest, (int)((double)this.m_map.size() * part));
    }

    public DictPair splitPart(String nameDict, String nameRest, int partSize) throws Exception {
        String nextSrc;
        if (partSize < 0) {
            throw new IllegalArgumentException();
        }
        int part = Math.min(this.m_map.size(), partSize);
        LinkedList keys = new LinkedList();
        DictPair pair = new DictPair(nameDict, nameRest);
        keys.addAll(this.m_map.keySet());
        int i = 0;
        while (i < part) {
            nextSrc = (String)keys.remove(this.m_rand.nextInt(keys.size()));
            pair.dict.m_map.put(nextSrc, this.m_map.get(nextSrc));
            ++i;
        }
        i = 0;
        while (i < keys.size()) {
            nextSrc = (String)keys.get(i);
            pair.rest.m_map.put(nextSrc, this.m_map.get(nextSrc));
            ++i;
        }
        return pair;
    }

    public void clear() {
        this.m_map.clear();
    }

    public Set<String> getAllSrc() {
        return new HashSet<String>((Collection)this.m_map.keySet());
    }

    public int size() {
        return this.m_map.size();
    }

    public Set<String> getAllTrg() {
        HashSet<String> allVals = new HashSet<String>();
        for (HashSet<String> valList : this.m_map.values()) {
            allVals.addAll(valList);
        }
        return allVals;
    }

    public Set<String> getTrg(String src) {
        return this.m_map.get(src);
    }

    public void write(String fileName) throws Exception {
        BufferedWriter writer = new BufferedWriter(new FileWriter(fileName));
        for (String key : this.m_map.keySet()) {
            for (String val : this.m_map.get(key)) {
                writer.write(String.valueOf(key) + "\t" + val);
                writer.newLine();
            }
        }
        writer.close();
    }

    protected void read(HashMap<String, HashSet<String>> hash, InputStreamReader dictReader) throws Exception {
        String line;
        BufferedReader reader = new BufferedReader(dictReader);
        while ((line = reader.readLine()) != null) {
            String[] toks = line.split("\\s");
            String srcTok = toks[0].toLowerCase();
            String trgTok = toks[1].toLowerCase();
            if (!this.isToken(srcTok) || !this.isToken(trgTok)) continue;
            HashSet<String> transSet = hash.get(srcTok);
            if (transSet == null) {
                transSet = new HashSet();
                hash.put(srcTok, transSet);
            }
            transSet.add(trgTok);
        }
        reader.close();
    }

    protected void read(HashMap<String, HashSet<String>> hash, InputStreamReader srcDictReader, InputStreamReader trgDictReader) throws Exception {
        String trgTok;
        String srcTok;
        BufferedReader srcReader = new BufferedReader(srcDictReader);
        BufferedReader trgReader = new BufferedReader(trgDictReader);
        while ((srcTok = srcReader.readLine()) != null && (trgTok = trgReader.readLine()) != null) {
            srcTok = srcTok.trim().toLowerCase();
            trgTok = trgTok.trim().toLowerCase();
            if (!this.isToken(srcTok) || !this.isToken(trgTok)) continue;
            HashSet<String> transSet = hash.get(srcTok);
            if (transSet == null) {
                transSet = new HashSet();
                hash.put(srcTok, transSet);
            }
            transSet.add(trgTok);
        }
        srcReader.close();
        trgReader.close();
    }

    public void pruneCounts(int numTrans) {
        if (numTrans < 0) {
            return;
        }
        HashSet<String> toRemove = new HashSet<String>();
        for (String name : this.m_map.keySet()) {
            if (this.m_map.get(name).size() < numTrans) continue;
            toRemove.add(name);
        }
        for (String name : toRemove) {
            this.m_map.remove(name);
        }
        System.out.println("Pruned words with more than " + numTrans + " translations, new size of " + this.m_name + " is " + this.m_map.size() + " src entries.");
    }

    public String toString() {
        return "SimpleDictionary [" + this.m_name + "] contains " + this.m_map.size() + " source entries.";
    }

    protected boolean isToken(String str) {
        return !str.matches(".*[,0-9_\\*\\.]+.*");
    }

    public static class DictHalves {
        public String srcDictFile;
        public String trgDictFile;

        public DictHalves(String srcDictFile, String trgDictFile) {
            assert (srcDictFile != null && trgDictFile != null && !srcDictFile.equals(trgDictFile));
            this.srcDictFile = srcDictFile;
            this.trgDictFile = trgDictFile;
        }
    }

    public class DictPair {
        public SimpleDictionary dict;
        public SimpleDictionary rest;

        public DictPair(String nameDict, String nameRest) {
            this.dict = new SimpleDictionary(nameDict);
            this.rest = new SimpleDictionary(nameRest);
        }
    }
}

