/*
 * Decompiled with CFR 0.152.
 */
package babel.prep.langidtime;

import babel.content.pages.Page;
import babel.content.pages.PageVersion;
import babel.util.language.GoogleLangDetector;
import babel.util.language.LangDetectionResult;
import babel.util.language.LangDetector;
import babel.util.language.Language;
import com.ibm.icu.text.DateFormat;
import com.ibm.icu.text.SimpleDateFormat;
import java.io.BufferedReader;
import java.io.FileReader;
import java.util.Date;
import java.util.HashMap;
import java.util.Locale;
import java.util.regex.Matcher;
import java.util.regex.Pattern;

public class URLAndContentsLangTimeExtractor {
    protected static Pattern DW_CONT_DATE_1 = Pattern.compile("Deutsche Welle \\| (\\d?\\d.\\d?\\d.\\d{4})");
    protected static DateFormat DW_CONT_DATEFORMAT_1 = new SimpleDateFormat("d.M.y");
    protected static DateFormat BBC_URL_DATEFORMAT = new SimpleDateFormat("yyMMdd");
    protected static Pattern BBC_EN_CONT_DATE_1 = Pattern.compile("\\d\\d:\\d\\d\\s[^\\s\\d]{3},\\s[^\\s\\d]+,\\s\\d?\\d\\s[^\\s\\d]+\\s\\d\\d\\d\\d");
    protected static DateFormat BBC_EN_CONT_DATEFORMAT_1 = new SimpleDateFormat("HH:mm zzz, E, d MMM y");
    protected static Pattern BBC_EN_CONT_DATE_2 = Pattern.compile("[^\\s\\d]+,\\s(\\d?\\d\\s[^\\s\\d]+,\\s\\d\\d\\d\\d,\\s\\d?\\d:\\d\\d\\s[^\\s\\d]{3})");
    protected static DateFormat BBC_EN_CONT_DATEFORMAT_2 = new SimpleDateFormat("d MMM, y, HH:mm zzz");
    protected static Pattern BBC_EN_CONT_DATE_3 = Pattern.compile("[^\\s\\d]+,\\s(\\d?\\d\\s[^\\s\\d]+\\s\\d\\d\\d\\d,\\s\\d?\\d:\\d\\d\\s[^\\s\\d]{3})");
    protected static DateFormat BBC_EN_CONT_DATEFORMAT_3 = new SimpleDateFormat("d MMM y, HH:mm zzz");
    protected static Pattern BBC_RU_CONT_DATE_1 = Pattern.compile("[^\\s\\d]+,\\s(\\d?\\d\\s[^\\s\\d]+\\s\\d\\d\\d\\d\\s\u2013\u2265.,\\s\\d?\\d:\\d\\d\\s[^\\s\\d]{3})");
    protected static DateFormat BBC_RU_CONT_DATEFORMAT_1 = new SimpleDateFormat("d MMM y \u2013\u2265., HH:mm zzz", new Locale("ru"));
    protected static Pattern BBC_AZ_CONT_DATE_1 = Pattern.compile("[\\D]+(\\d?\\d\\s[^\\s\\d]+,\\s\\d\\d\\d\\d)\\s-\\sPublished(\\s\\d?\\d:\\d\\d\\s[^\\s\\d]{3})");
    protected static DateFormat BBC_AZ_CONT_DATEFORMAT_1 = new SimpleDateFormat("d MMM, y HH:mm zzz", new Locale("az"));
    protected static Pattern BBC_SQ_CONT_DATE_1 = Pattern.compile("[\\D]+,\\s(\\d?\\d\\s[^\\s\\d]+\\s\\d\\d\\d\\d\\s-\\s\\d?\\d:\\d\\d\\s[^\\s\\d]{3})");
    protected static DateFormat BBC_SQ_CONT_DATEFORMAT_1 = new SimpleDateFormat("d MMM y - HH:mm zzz", new Locale("sq"));
    protected static Pattern BBC_CY_CONT_DATE_1 = Pattern.compile("[^\\s\\d]+,\\s(\\d?\\d\\s[^\\s\\d]+,\\s\\d\\d\\d\\d,\\s\\d?\\d:\\d\\d\\s[^\\s\\d]{3})");
    protected static DateFormat BBC_CY_CONT_DATEFORMAT_1 = new SimpleDateFormat("d MMM, y, HH:mm zzz", new Locale("cy"));
    protected static Pattern BBC_ES_CONT_DATE_1 = Pattern.compile("[^\\s\\d]+,\\s(\\d?\\d\\s[\\D]+\\s\\d{4})\\s+-\\s+(\\d?\\d:\\d\\d\\s[^\\s\\d]{3})");
    protected static DateFormat BBC_ES_CONT_DATEFORMAT_1 = DateFormat.getDateInstance((int)1, (Locale)new Locale("es"));
    protected static Pattern BBC_BN_CONT_DATE_1 = Pattern.compile("[\\D]*(\\d?\\d\\s[^\\s\\d]+\\s\\d\\d\\d\\d\\s-\\s\\d?\\d:\\d\\d)");
    protected static DateFormat BBC_BN_CONT_DATEFORMAT_1 = new SimpleDateFormat("d MMM y - HH:mm", new Locale("bn"));
    protected static Pattern BBC_ZH_CONT_DATE_1 = Pattern.compile("(\\d{4})\u00c2\u03c0\u00a5\\s*(\\d?\\d)\u00ca\u00fa\u00e0\\s*(\\d?\\d)\u00ca\u00f3\u2022");
    protected static DateFormat BBC_ZH_CONT_DATEFORMAT_1 = new SimpleDateFormat("y M d");
    protected static Pattern VOA_URL_DATE_ONE = Pattern.compile("\\d\\d\\d\\d_\\d?\\d_\\d?\\d");
    protected static DateFormat VOA_URL_DATEFORMAT_ONE = new SimpleDateFormat("yyyy_M_d");
    protected static Pattern VOA_URL_DATE_TWO = Pattern.compile("\\d\\d\\d\\d-\\d?\\d-\\d?\\d");
    protected static DateFormat VOA_URL_DATEFORMAT_TWO = new SimpleDateFormat("yyyy-M-d");
    protected static Pattern VOA_URL_DATE_THREE = Pattern.compile("\\d?\\d-\\d?\\d-\\d\\d\\d\\d");
    protected static DateFormat VOA_URL_DATEFORMAT_THREE = new SimpleDateFormat("M-d-yyyy");
    protected static Pattern VOA_URL_DATE_FOUR = Pattern.compile("\\d\\d\\D\\D\\D\\d\\d");
    protected static DateFormat VOA_URL_DATEFORMAT_FOUR = new SimpleDateFormat("ddMMMyy");
    protected static Pattern VOA_FA_CONT_DATE_1 = Pattern.compile("(\\d?\\d.\\d?\\d.\\d\\d)");
    protected static DateFormat VOA_FA_CONT_DATEFORMAT_1 = new SimpleDateFormat("d.M.yy");
    protected static Pattern VOA_SO_CONT_DATE_1 = Pattern.compile("\\D+(\\d?\\d\\s+[\\D\\S]+\\s+\\d{4})");
    protected static DateFormat VOA_SO_CONT_DATEFORMAT_1 = new SimpleDateFormat("d MMM yy");
    protected static Pattern LENTA_URL_DATE = Pattern.compile("\\d\\d\\d\\d/\\d\\d/\\d\\d");
    protected static DateFormat LENTA_URL_DATEFORMAT = new SimpleDateFormat("yyyy/MM/dd");
    protected static Pattern ATLAS_DATE = Pattern.compile("(\\d?\\d\\.\\s*[^\\s\\d]+\\s\\d{4})\\D(\\d?\\d:\\d\\d)");
    protected static DateFormat ATLAS_DATEFORMAT = new SimpleDateFormat("d. MMM yyyy HH:mm", new Locale("sk"));
    protected static Pattern INFOKAZ_DATE = Pattern.compile("\\d?\\d\\.\\d?\\d.\\d{4}\\s/\\s\\d?\\d:\\d\\d");
    protected static DateFormat INFOKAZ_DATEFORMAT = new SimpleDateFormat("d.M.yyyy / HH:mm");
    protected static Pattern DIENA_DATE = Pattern.compile(",\\s+(\\d?\\d\\.\\s[^\\s\\d]+\\s\\(\\d{4}\\) \\d?\\d:\\d\\d)");
    protected static DateFormat DIENA_DATEFORMAT = new SimpleDateFormat("d. MMM (yyyy) HH:mm", new Locale("lv"));
    protected static Pattern AZATLIQ_DATE = Pattern.compile("\\d?\\d\\.\\d?\\d.\\d{4}");
    protected static DateFormat AZATLIQ_DATEFORMAT = new SimpleDateFormat("d.M.yyyy ");
    protected HashMap<String, LangDetectionResult> m_bbcURLLangs = new HashMap();
    protected HashMap<String, LangDetectionResult> m_voaURLLangs;
    private LangDetector m_detector;

    public URLAndContentsLangTimeExtractor(String referrer) {
        this.m_bbcURLLangs.put("^bbc.co.uk/(hi/|low/)?azeri/.*", new LangDetectionResult(Language.AZERBAIJANI));
        this.m_bbcURLLangs.put("^bbc.co.uk/(hi/|low/)?albanian/.*", new LangDetectionResult(Language.ALBANIAN));
        this.m_bbcURLLangs.put("^bbc.co.uk/(hi/|low/)?bengali/.*", new LangDetectionResult(Language.BENGALI));
        this.m_bbcURLLangs.put("^bbc.co.uk/(hi/|low/)?persian/.*", new LangDetectionResult(Language.PERSIAN));
        this.m_bbcURLLangs.put("^bbc.co.uk/(hi/|low/)?hindi/.*", new LangDetectionResult(Language.HINDI));
        this.m_bbcURLLangs.put("^bbc.co.uk/(hi/|low/)?arabic/.*", new LangDetectionResult(Language.ARABIC));
        this.m_bbcURLLangs.put("^bbc.co.uk/(hi/|low/)?indonesia/.*", new LangDetectionResult(Language.INDONESIAN));
        this.m_bbcURLLangs.put("^bbc.co.uk/(hi/|low/)?irish/.*", new LangDetectionResult(Language.IRISH));
        this.m_bbcURLLangs.put("^bbc.co.uk/(hi/|low/)?kyrgyz/.*", new LangDetectionResult(Language.KYRGYZ));
        this.m_bbcURLLangs.put("^bbc.co.uk/(hi/|low/)?nepali/.*", new LangDetectionResult(Language.NEPALI));
        this.m_bbcURLLangs.put("^bbc.co.uk/(hi/|low/)?russian/.*", new LangDetectionResult(Language.RUSSIAN));
        this.m_bbcURLLangs.put("^bbc.co.uk/(hi/|low/)?pashto/.*", new LangDetectionResult(Language.PASHTO));
        this.m_bbcURLLangs.put("^bbc.co.uk/(hi/|low/)?serbian/.*", new LangDetectionResult(Language.SERBIAN));
        this.m_bbcURLLangs.put("^bbc.co.uk/(hi/|low/)?somali/.*", new LangDetectionResult(Language.SOMALI));
        this.m_bbcURLLangs.put("^bbc.co.uk/(hi/|low/)?tamil/.*", new LangDetectionResult(Language.TAMIL));
        this.m_bbcURLLangs.put("^bbc.co.uk/(hi/|low/)?turkce/.*", new LangDetectionResult(Language.TURKISH));
        this.m_bbcURLLangs.put("^bbc.co.uk/(hi/|low/)?turkish/.*", new LangDetectionResult(Language.TURKISH));
        this.m_bbcURLLangs.put("^bbc.co.uk/(hi/|low/)?ukrainian/.*", new LangDetectionResult(Language.UKRANIAN));
        this.m_bbcURLLangs.put("^bbc.co.uk/(hi/|low/)?urdu/.*", new LangDetectionResult(Language.URDU));
        this.m_bbcURLLangs.put("^bbc.co.uk/(hi/|low/)?uzbek/.*", new LangDetectionResult(Language.UZBEK));
        this.m_bbcURLLangs.put("^bbc.co.uk/(hi/|low/)?cymru/.*", new LangDetectionResult(Language.WELSH));
        this.m_bbcURLLangs.put("^bbc.co.uk/(hi/|low/)?welsh/.*", new LangDetectionResult(Language.WELSH));
        this.m_bbcURLLangs.put("^bbc.co.uk/(hi/|low/)?mundo/.*", new LangDetectionResult(Language.SPANISH));
        this.m_bbcURLLangs.put("^bbc.co.uk/(hi/|low/)?spanish/.*", new LangDetectionResult(Language.SPANISH));
        this.m_bbcURLLangs.put("^bbc.co.uk/(hi/|low/)?chinese/simp/.*", new LangDetectionResult(Language.CHINESE_SIMPLIFIED));
        this.m_bbcURLLangs.put("^bbc.co.uk/(hi/|low/)?chinese/trad/.*", new LangDetectionResult(Language.CHINESE_TRADITIONAL));
        this.m_bbcURLLangs.put("^bbc.co.uk/(hi/|low/)?ukchina/simp/.*", new LangDetectionResult(Language.CHINESE_SIMPLIFIED));
        this.m_bbcURLLangs.put("^bbc.co.uk/(hi/|low/)?ukchina/trad/.*", new LangDetectionResult(Language.CHINESE_TRADITIONAL));
        this.m_bbcURLLangs.put("^bbc.co.uk/(hi/|low/)?zhongwen/simp/.*", new LangDetectionResult(Language.CHINESE_SIMPLIFIED));
        this.m_bbcURLLangs.put("^bbc.co.uk/(hi/|low/)?zhongwen/trad/.*", new LangDetectionResult(Language.CHINESE_TRADITIONAL));
        this.m_bbcURLLangs.put("^bbc.co.uk/(hi/|low/)?english/.*", new LangDetectionResult(Language.ENGLISH));
        this.m_bbcURLLangs.put("^bbc.co.uk/local/.*", new LangDetectionResult(Language.ENGLISH));
        this.m_bbcURLLangs.put("^bbc.co.uk/[12]/.*", new LangDetectionResult(Language.ENGLISH));
        this.m_voaURLLangs = new HashMap();
        this.m_voaURLLangs.put("^voanews.com/armenian/.*", new LangDetectionResult(Language.ARMENIAN));
        this.m_voaURLLangs.put("^voanews.com/bosnian/.*", new LangDetectionResult(Language.BOSNIAN));
        this.m_voaURLLangs.put("^voanews.com/azerbaijani/.*", new LangDetectionResult(Language.AZERBAIJANI));
        this.m_voaURLLangs.put("^voanews.com/indonesian/.*", new LangDetectionResult(Language.INDONESIAN));
        this.m_voaURLLangs.put("^voanews.com/pashto/.*", new LangDetectionResult(Language.PASHTO));
        this.m_voaURLLangs.put("^voanews.com/persian/.*", new LangDetectionResult(Language.PERSIAN));
        this.m_voaURLLangs.put("^voanews.com/russian/.*", new LangDetectionResult(Language.RUSSIAN));
        this.m_voaURLLangs.put("^voanews.com/somali/.*", new LangDetectionResult(Language.SOMALI));
        this.m_voaURLLangs.put("^voanews.com/swahili/.*", new LangDetectionResult(Language.SWAHILI));
        this.m_voaURLLangs.put("^voanews.com/thai/.*", new LangDetectionResult(Language.THAI));
        this.m_voaURLLangs.put("^voanews.com/turkish/.*", new LangDetectionResult(Language.TURKISH));
        this.m_voaURLLangs.put("^voanews.com/ukrainian/.*", new LangDetectionResult(Language.UKRANIAN));
        this.m_voaURLLangs.put("^voanews.com/urdu/.*", new LangDetectionResult(Language.URDU));
        this.m_voaURLLangs.put("^voanews.com/uzbek/.*", new LangDetectionResult(Language.UZBEK));
        this.m_voaURLLangs.put("^voanews.com/chinese/.*", new LangDetectionResult(Language.CHINESE));
        this.m_detector = new GoogleLangDetector(referrer);
    }

    public static void main(String[] str) throws Exception {
        URLAndContentsLangTimeExtractor d = new URLAndContentsLangTimeExtractor("http://www.clsp.jhu.edu");
        Date date = d.detectDWDateFromContent(URLAndContentsLangTimeExtractor.readFileAsString("test/0,,5787445,00.html"));
        System.out.println(date);
    }

    private static String readFileAsString(String path) throws Exception {
        StringBuilder fileData = new StringBuilder();
        BufferedReader reader = new BufferedReader(new FileReader(path));
        char[] buf = new char[1024];
        int numRead = 0;
        while ((numRead = reader.read(buf)) != -1) {
            String readData = String.valueOf(buf, 0, numRead);
            fileData.append(readData);
        }
        reader.close();
        return fileData.toString();
    }

    public DetectionResult detect(Page page) {
        DetectionResult result = null;
        if (page != null) {
            try {
                result = this.detectBBC(page);
                if (result == null && (result = this.detectVoA(page)) == null && (result = this.detectDW(page)) == null && (result = this.detectLenta(page)) == null && (result = this.detectAtlas(page)) == null && (result = this.detectInformKaz(page)) == null && (result = this.detectDienaLv(page)) == null && (result = this.detectAzatliqKy(page)) == null && (result = this.detectOther(page)) != null) {
                    // empty if block
                }
            }
            catch (Exception e) {
                result = null;
            }
        }
        return result;
    }

    protected DetectionResult detectOther(Page page) {
        DetectionResult result = null;
        try {
            LangDetectionResult langResult = this.getOrGoogDetectLang(page);
            if (langResult != null) {
                result = new DetectionResult(langResult);
            }
        }
        catch (Exception exception) {
            // empty catch block
        }
        return result;
    }

    protected DetectionResult detectDW(Page page) {
        DetectionResult result = null;
        String url = this.removeProtocol(page.pageURL());
        if (url.matches("^(www.)?dw-world.de.*")) {
            try {
                LangDetectionResult langResult = this.getOrGoogDetectLang(page);
                if (langResult != null) {
                    result = new DetectionResult(langResult);
                    Date modTime = null;
                    for (PageVersion ver : page.pageVersions()) {
                        modTime = this.detectDWDateFromContent(ver.getContent());
                        if (modTime == null) continue;
                        result.addModTime(ver, modTime);
                    }
                }
            }
            catch (Exception exception) {
                // empty catch block
            }
        }
        return result;
    }

    protected LangDetectionResult getOrGoogDetectLang(Page page) throws Exception {
        Language lang = page.getLanguage();
        return lang == null ? this.m_detector.detect(page.pageVersions().get(0).getContent()) : new LangDetectionResult(lang);
    }

    protected Date detectDWDateFromContent(String content) {
        Date modTime = null;
        Matcher m = null;
        try {
            m = DW_CONT_DATE_1.matcher(content);
            if (m.find()) {
                modTime = DW_CONT_DATEFORMAT_1.parse(content.substring(m.start(1), m.end(1)));
            }
        }
        catch (Exception exception) {
            // empty catch block
        }
        return modTime;
    }

    protected DetectionResult detectBBC(Page page) {
        DetectionResult result = null;
        String url = this.removeProtocolAndPrefix(page.pageURL());
        LangDetectionResult langResult = null;
        Date modTime = null;
        for (String pref : this.m_bbcURLLangs.keySet()) {
            if (!url.matches(pref)) continue;
            langResult = this.m_bbcURLLangs.get(pref);
            break;
        }
        if (langResult != null) {
            result = new DetectionResult(langResult);
            modTime = this.detectBBCDateFromURL(url);
            if (modTime == null) {
                for (PageVersion ver : page.pageVersions()) {
                    modTime = this.detectBBCDateFromContent(langResult.language(), ver.getContent());
                    if (modTime == null) continue;
                    result.addModTime(ver, modTime);
                }
            } else {
                result.addModTimeAllVers(page, modTime);
            }
        }
        return result;
    }

    protected Date detectBBCDateFromURL(String url) {
        Date modTime = null;
        try {
            int slashIdx = url.lastIndexOf("/");
            int underscoreIdx = url.indexOf("_", slashIdx);
            if (underscoreIdx - slashIdx == 7) {
                String dateStamp = url.substring(slashIdx + 1, underscoreIdx);
                modTime = BBC_URL_DATEFORMAT.parse(dateStamp);
            }
        }
        catch (Exception e) {
            modTime = null;
        }
        return modTime;
    }

    protected Date detectBBCDateFromContent(Language lang, String content) {
        Date modTime = null;
        if (Language.ENGLISH.equals((Object)lang)) {
            modTime = this.detectBBCDateFromEnContent(content);
        } else if (Language.RUSSIAN.equals((Object)lang)) {
            modTime = this.detectBBCDateFromRuContent(content);
        } else if (Language.AZERBAIJANI.equals((Object)lang)) {
            modTime = this.detectBBCDateFromAzContent(content);
        } else if (Language.ALBANIAN.equals((Object)lang)) {
            modTime = this.detectBBCDateFromSqContent(content);
        } else if (Language.BENGALI.equals((Object)lang)) {
            modTime = this.detectBBCDateFromBnContent(content);
        } else if (Language.WELSH.equals((Object)lang)) {
            modTime = this.detectBBCDateFromCyContent(content);
        } else if (Language.SPANISH.equals((Object)lang)) {
            modTime = this.detectBBCDateFromEsContent(content);
        } else if (Language.CHINESE.equals((Object)lang)) {
            modTime = this.detectBBCDateFromZhContent(content);
        }
        return modTime;
    }

    protected Date detectBBCDateFromEnContent(String content) {
        Date modTime = null;
        Matcher m = null;
        try {
            m = BBC_EN_CONT_DATE_1.matcher(content);
            if (m.find()) {
                modTime = BBC_EN_CONT_DATEFORMAT_1.parse(content.substring(m.start(0), m.end(0)));
            }
        }
        catch (Exception exception) {
            // empty catch block
        }
        if (modTime == null) {
            try {
                m = BBC_EN_CONT_DATE_2.matcher(content);
                if (m.find()) {
                    modTime = BBC_EN_CONT_DATEFORMAT_2.parse(content.substring(m.start(1), m.end(1)));
                }
            }
            catch (Exception exception) {
                // empty catch block
            }
        }
        if (modTime == null) {
            try {
                m = BBC_EN_CONT_DATE_3.matcher(content);
                if (m.find()) {
                    modTime = BBC_EN_CONT_DATEFORMAT_3.parse(content.substring(m.start(1), m.end(1)));
                }
            }
            catch (Exception exception) {
                // empty catch block
            }
        }
        return modTime;
    }

    protected Date detectBBCDateFromRuContent(String content) {
        Date modTime = null;
        Matcher m = null;
        try {
            m = BBC_RU_CONT_DATE_1.matcher(content);
            if (m.find()) {
                modTime = BBC_RU_CONT_DATEFORMAT_1.parse(content.substring(m.start(1), m.end(1)));
            }
        }
        catch (Exception exception) {
            // empty catch block
        }
        return modTime;
    }

    protected Date detectBBCDateFromAzContent(String content) {
        Date modTime = null;
        Matcher m = null;
        try {
            m = BBC_AZ_CONT_DATE_1.matcher(content);
            if (m.find()) {
                modTime = BBC_AZ_CONT_DATEFORMAT_1.parse(String.valueOf(content.substring(m.start(1), m.end(1))) + content.substring(m.start(2), m.end(2)));
            }
        }
        catch (Exception exception) {
            // empty catch block
        }
        return modTime;
    }

    protected Date detectBBCDateFromSqContent(String content) {
        Date modTime = null;
        Matcher m = null;
        try {
            m = BBC_SQ_CONT_DATE_1.matcher(content);
            if (m.find()) {
                modTime = BBC_SQ_CONT_DATEFORMAT_1.parse(content.substring(m.start(1), m.end(1)));
            }
        }
        catch (Exception exception) {
            // empty catch block
        }
        return modTime;
    }

    protected Date detectBBCDateFromBnContent(String content) {
        Date modTime = null;
        Matcher m = null;
        try {
            m = BBC_BN_CONT_DATE_1.matcher(content);
            if (m.find()) {
                modTime = BBC_BN_CONT_DATEFORMAT_1.parse(content.substring(m.start(1), m.end(1)));
            }
        }
        catch (Exception exception) {
            // empty catch block
        }
        return modTime;
    }

    protected Date detectBBCDateFromCyContent(String content) {
        Date modTime = null;
        Matcher m = null;
        try {
            m = BBC_CY_CONT_DATE_1.matcher(content);
            if (m.find()) {
                modTime = BBC_CY_CONT_DATEFORMAT_1.parse(content.substring(m.start(1), m.end(1)));
            }
        }
        catch (Exception exception) {
            // empty catch block
        }
        return modTime;
    }

    protected Date detectBBCDateFromEsContent(String content) {
        Date modTime = null;
        Matcher m = null;
        try {
            m = BBC_ES_CONT_DATE_1.matcher(content);
            if (m.find()) {
                modTime = BBC_ES_CONT_DATEFORMAT_1.parse(content.substring(m.start(1), m.end(1)));
            }
        }
        catch (Exception exception) {
            // empty catch block
        }
        return modTime;
    }

    protected Date detectBBCDateFromZhContent(String content) {
        Date modTime = null;
        Matcher m = null;
        try {
            m = BBC_ZH_CONT_DATE_1.matcher(content);
            if (m.find()) {
                modTime = BBC_ZH_CONT_DATEFORMAT_1.parse(String.valueOf(content.substring(m.start(1), m.end(1))) + " " + content.substring(m.start(2), m.end(2)) + " " + content.substring(m.start(3), m.end(3)));
            }
        }
        catch (Exception exception) {
            // empty catch block
        }
        return modTime;
    }

    protected DetectionResult detectVoA(Page page) {
        DetectionResult result = null;
        String url = this.removeProtocolAndPrefix(page.pageURL());
        LangDetectionResult langResult = null;
        Date modTime = null;
        for (String pref : this.m_voaURLLangs.keySet()) {
            if (!url.matches(pref)) continue;
            langResult = this.m_voaURLLangs.get(pref);
            break;
        }
        if (langResult != null) {
            result = new DetectionResult(langResult);
            modTime = this.detectVoADateFromURL(url);
            if (modTime == null) {
                for (PageVersion ver : page.pageVersions()) {
                    modTime = this.detectVoADateFromContent(langResult.language(), ver.getContent());
                    if (modTime == null) continue;
                    result.addModTime(ver, modTime);
                }
            } else {
                result.addModTimeAllVers(page, modTime);
            }
        }
        return result;
    }

    protected Date detectVoADateFromURL(String url) {
        Date modTime = null;
        try {
            String fileName = url.substring(url.lastIndexOf("/") + 1);
            Matcher m = null;
            m = VOA_URL_DATE_ONE.matcher(fileName);
            if (m != null && m.find()) {
                modTime = VOA_URL_DATEFORMAT_ONE.parse(m.group());
            } else {
                m = VOA_URL_DATE_TWO.matcher(fileName);
                if (m != null && m.find()) {
                    modTime = VOA_URL_DATEFORMAT_TWO.parse(m.group());
                } else {
                    m = VOA_URL_DATE_THREE.matcher(fileName);
                    if (m != null && m.find()) {
                        modTime = VOA_URL_DATEFORMAT_THREE.parse(m.group());
                    } else {
                        m = VOA_URL_DATE_FOUR.matcher(fileName);
                        if (m != null && m.find()) {
                            modTime = VOA_URL_DATEFORMAT_FOUR.parse(m.group());
                        }
                    }
                }
            }
        }
        catch (Exception exception) {
            // empty catch block
        }
        return modTime;
    }

    protected Date detectVoADateFromContent(Language lang, String content) {
        Date modTime = null;
        if (Language.CHINESE.equals((Object)lang)) {
            modTime = this.detectBBCDateFromZhContent(content);
        } else if (Language.PASHTO.equals((Object)lang)) {
            modTime = this.detectVoADateFromFaContent(content);
        } else if (Language.SOMALI.equals((Object)lang)) {
            modTime = this.detectVoADateFromSoContent(content);
        }
        return modTime;
    }

    protected Date detectVoADateFromFaContent(String content) {
        Date modTime = null;
        Matcher m = null;
        try {
            m = VOA_FA_CONT_DATE_1.matcher(content);
            if (m.find()) {
                modTime = VOA_FA_CONT_DATEFORMAT_1.parse(content.substring(m.start(1), m.end(1)));
            }
        }
        catch (Exception exception) {
            // empty catch block
        }
        return modTime;
    }

    protected Date detectVoADateFromSoContent(String content) {
        Date modTime = null;
        Matcher m = null;
        try {
            m = VOA_SO_CONT_DATE_1.matcher(content);
            if (m.find()) {
                modTime = VOA_SO_CONT_DATEFORMAT_1.parse(content.substring(m.start(1), m.end(1)));
            }
        }
        catch (Exception exception) {
            // empty catch block
        }
        return modTime;
    }

    protected DetectionResult detectLenta(Page page) {
        DetectionResult result = null;
        String url = this.removeProtocol(page.pageURL());
        Date modTime = null;
        if (url.matches("^(www.)?lenta.ru.*")) {
            try {
                Matcher m = LENTA_URL_DATE.matcher(url);
                if (m.find()) {
                    modTime = LENTA_URL_DATEFORMAT.parse(m.group());
                }
            }
            catch (Exception exception) {
                // empty catch block
            }
            result = new DetectionResult(new LangDetectionResult(Language.RUSSIAN));
            result.addModTimeAllVers(page, modTime);
        }
        return result;
    }

    protected DetectionResult detectAtlas(Page page) {
        DetectionResult result = null;
        String url = this.removeProtocol(page.pageURL());
        if (url.startsWith("dnes.atlas.sk")) {
            result = new DetectionResult(new LangDetectionResult(Language.SLOVAK));
            for (PageVersion ver : page.pageVersions()) {
                String content = ver.getContent();
                Matcher m = ATLAS_DATE.matcher(content);
                boolean gotit = false;
                while (!gotit && m.find()) {
                    try {
                        result.addModTime(ver, ATLAS_DATEFORMAT.parse(String.valueOf(content.substring(m.start(1), m.end(1))) + " " + content.substring(m.start(2), m.end(2))));
                        gotit = true;
                    }
                    catch (Exception exception) {
                        // empty catch block
                    }
                }
            }
        }
        return result;
    }

    protected DetectionResult detectInformKaz(Page page) {
        DetectionResult result = null;
        String url = this.removeProtocol(page.pageURL());
        if (url.matches("^(www.)?inform.kz/kaz/.*")) {
            result = new DetectionResult(new LangDetectionResult(Language.KAZAKH));
            for (PageVersion ver : page.pageVersions()) {
                try {
                    String content = ver.getContent();
                    Matcher m = INFOKAZ_DATE.matcher(content);
                    if (!m.find()) continue;
                    result.addModTime(ver, INFOKAZ_DATEFORMAT.parse(content.substring(m.start(0), m.end(0))));
                }
                catch (Exception exception) {
                    // empty catch block
                }
            }
        }
        return result;
    }

    protected DetectionResult detectDienaLv(Page page) {
        DetectionResult result = null;
        String url = this.removeProtocol(page.pageURL());
        if (url.matches("^(www.)?diena.lv/lat.*")) {
            result = new DetectionResult(new LangDetectionResult(Language.LATVIAN));
            for (PageVersion ver : page.pageVersions()) {
                try {
                    String content = ver.getContent();
                    Matcher m = DIENA_DATE.matcher(content);
                    if (!m.find()) continue;
                    result.addModTime(ver, DIENA_DATEFORMAT.parse(content.substring(m.start(1), m.end(1))));
                }
                catch (Exception exception) {
                    // empty catch block
                }
            }
        }
        return result;
    }

    protected DetectionResult detectAzatliqKy(Page page) {
        DetectionResult result = null;
        String url = this.removeProtocol(page.pageURL());
        if (url.matches("^(www.)?azatliq.org.*")) {
            result = new DetectionResult(new LangDetectionResult(Language.KYRGYZ));
            for (PageVersion ver : page.pageVersions()) {
                try {
                    String content = ver.getContent();
                    Matcher m = AZATLIQ_DATE.matcher(content);
                    if (!m.find()) continue;
                    result.addModTime(ver, AZATLIQ_DATEFORMAT.parse(content.substring(m.start(0), m.end(0))));
                }
                catch (Exception exception) {
                    // empty catch block
                }
            }
        }
        return result;
    }

    protected String removeProtocolAndPrefix(String url) {
        return url.substring(url.indexOf(".") + 1).toLowerCase();
    }

    protected String removeProtocol(String url) {
        return url.substring(url.indexOf("://") + 3).toLowerCase();
    }

    public class DetectionResult {
        HashMap<PageVersion, Date> m_modTimes = new HashMap();
        LangDetectionResult m_langDet;

        public DetectionResult(LangDetectionResult langDet) {
            this.m_langDet = langDet;
        }

        public void addModTime(PageVersion ver, Date modTime) {
            if (modTime != null) {
                this.m_modTimes.put(ver, modTime);
            }
        }

        public void addModTimeAllVers(Page page, Date modTime) {
            if (modTime != null) {
                for (PageVersion ver : page.pageVersions()) {
                    this.m_modTimes.put(ver, modTime);
                }
            }
        }

        public String toString() {
            StringBuilder strBld = new StringBuilder();
            if (this.m_langDet != null) {
                strBld.append("Lang: ");
                strBld.append((Object)this.m_langDet.language());
                strBld.append(" ");
            }
            if (this.m_modTimes.size() > 0) {
                strBld.append("Time:");
            }
            for (PageVersion ver : this.m_modTimes.keySet()) {
                strBld.append(" " + this.m_modTimes.get(ver));
            }
            return strBld.toString();
        }
    }
}

