/*
 * Decompiled with CFR 0.152.
 */
package org.maltparser.parser.algorithm.ucovington;

import java.util.Set;
import java.util.SortedSet;
import org.maltparser.core.exception.MaltChainedException;
import org.maltparser.core.syntaxgraph.DependencyStructure;
import org.maltparser.core.syntaxgraph.edge.Edge;
import org.maltparser.core.syntaxgraph.node.DependencyNode;
import org.maltparser.core.syntaxgraph.node.TokenNode;
import org.maltparser.parser.DependencyParserConfig;
import org.maltparser.parser.Oracle;
import org.maltparser.parser.ParserConfiguration;
import org.maltparser.parser.algorithm.ucovington.UcovingtonConfig;
import org.maltparser.parser.history.GuideUserHistory;
import org.maltparser.parser.history.action.GuideUserAction;

public class UcovingtonOracle
extends Oracle {
    public UcovingtonOracle(DependencyParserConfig manager, GuideUserHistory history) throws MaltChainedException {
        super(manager, history);
        this.setGuideName("NonProjective");
    }

    public GuideUserAction predict(DependencyStructure gold, ParserConfiguration config) throws MaltChainedException {
        int rightTargetIndex;
        UcovingtonConfig covingtonConfig = (UcovingtonConfig)config;
        DependencyNode leftTarget = covingtonConfig.getLeftTarget();
        int leftTargetIndex = leftTarget.getIndex();
        if (this.checkIfNodesAreRelated(gold, leftTargetIndex, rightTargetIndex = covingtonConfig.getRightTarget().getIndex())) {
            return this.updateActionContainers(3, this.getEdgeGraph(gold, leftTargetIndex, rightTargetIndex).getLabelSet());
        }
        if (covingtonConfig.isAllowShift() && (!gold.getTokenNode(rightTargetIndex).hasLeftDependent() || gold.getTokenNode(rightTargetIndex).getLeftmostDependent().getIndex() >= leftTargetIndex) && (gold.getTokenNode(rightTargetIndex).getHead().getIndex() >= leftTargetIndex || gold.getTokenNode(rightTargetIndex).getHead().isRoot() && covingtonConfig.getLeftstop() != 0)) {
            return this.updateActionContainers(1, null);
        }
        return this.updateActionContainers(2, null);
    }

    public void finalizeSentence(DependencyStructure dependencyGraph) throws MaltChainedException {
    }

    public void terminate() throws MaltChainedException {
    }

    private boolean checkIfNodesAreRelated(DependencyStructure dg, int index1, int index2) throws MaltChainedException {
        TokenNode tk = dg.getTokenNode(index1);
        Set<DependencyNode> heads = null;
        if (tk != null) {
            heads = tk.getHeads();
            for (DependencyNode head : heads) {
                if (head.getIndex() != index2) continue;
                return true;
            }
        }
        if ((tk = dg.getTokenNode(index2)) != null) {
            heads = tk.getHeads();
            for (DependencyNode head : heads) {
                if (head.getIndex() != index1) continue;
                return true;
            }
        }
        return false;
    }

    private Edge getEdgeGraph(DependencyStructure dg, int index1, int index2) throws MaltChainedException {
        SortedSet<Edge> arcos = dg.getEdges();
        for (Edge arco : arcos) {
            if (arco.getSource().getIndex() == index1 && arco.getTarget().getIndex() == index2) {
                return arco;
            }
            if (arco.getSource().getIndex() != index2 || arco.getTarget().getIndex() != index1) continue;
            return arco;
        }
        return null;
    }
}

