/*
 * Decompiled with CFR 0.152.
 */
package org.maltparser.parser.algorithm.ucovington;

import java.util.ArrayList;
import java.util.Iterator;
import org.maltparser.core.exception.MaltChainedException;
import org.maltparser.core.symbol.SymbolTable;
import org.maltparser.core.symbol.SymbolTableHandler;
import org.maltparser.core.syntaxgraph.DependencyGraph;
import org.maltparser.core.syntaxgraph.DependencyStructure;
import org.maltparser.core.syntaxgraph.edge.Edge;
import org.maltparser.core.syntaxgraph.node.DependencyNode;
import org.maltparser.core.syntaxgraph.node.TokenNode;
import org.maltparser.parser.ParserConfiguration;
import org.maltparser.parser.ParsingException;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class UcovingtonConfig
extends ParserConfiguration {
    private ArrayList<DependencyNode> input = new ArrayList();
    private int right;
    private int left;
    private int leftstop;
    private int rightstop;
    private DependencyStructure dependencyGraph;
    private boolean allowRoot;
    private boolean allowShift;
    private String mode;
    private String heuristic;

    public UcovingtonConfig(SymbolTableHandler symbolTableHandler, boolean cr, boolean cs, String mode, String heuristic) throws MaltChainedException {
        this.dependencyGraph = new DependencyGraph(symbolTableHandler);
        ((DependencyGraph)this.dependencyGraph).setSingleHeadedConstraint(false);
        this.setAllowRoot(cr);
        this.setAllowShift(cs);
        this.setMode(mode);
        this.setHeuristic(heuristic);
    }

    public void setHeuristic(String h) {
        this.heuristic = h;
    }

    public String getHeuristic() {
        return this.heuristic;
    }

    public void setMode(String s) {
        this.mode = s;
    }

    public String getMode() {
        return this.mode;
    }

    public DependencyStructure getDependencyStructure() {
        return this.dependencyGraph;
    }

    public ArrayList<DependencyNode> getInput() {
        return this.input;
    }

    @Override
    public boolean isTerminalState() {
        return this.right > this.rightstop;
    }

    public int getRight() {
        return this.right;
    }

    public void setRight(int right) {
        this.right = right;
    }

    public int getLeft() {
        return this.left;
    }

    public void setLeft(int left) {
        this.left = left;
    }

    public int getLeftstop() {
        return this.leftstop;
    }

    public int getRightstop() {
        return this.rightstop;
    }

    public boolean isAllowRoot() {
        return this.allowRoot;
    }

    public void setAllowRoot(boolean allowRoot) {
        this.allowRoot = allowRoot;
    }

    public boolean isAllowShift() {
        return this.allowShift;
    }

    public void setAllowShift(boolean allowShift) {
        this.allowShift = allowShift;
    }

    public DependencyNode getLeftNode(int index) throws MaltChainedException {
        if (index < 0) {
            throw new ParsingException("Left index must be non-negative in feature specification. ");
        }
        if (this.left - index >= 0) {
            return this.input.get(this.left - index);
        }
        return null;
    }

    public DependencyNode getRightNode(int index) throws MaltChainedException {
        if (index < 0) {
            throw new ParsingException("Right index must be non-negative in feature specification. ");
        }
        if (this.right + index < this.input.size()) {
            return this.input.get(this.right + index);
        }
        return null;
    }

    public DependencyNode getLeftContextNode(int index) throws MaltChainedException {
        if (index < 0) {
            throw new ParsingException("LeftContext index must be non-negative in feature specification. ");
        }
        int tmpindex = 0;
        for (int i = this.left + 1; i < this.right; ++i) {
            if (tmpindex == index) {
                return this.input.get(i);
            }
            ++tmpindex;
        }
        return null;
    }

    public DependencyNode getRightContextNode(int index) throws MaltChainedException {
        if (index < 0) {
            throw new ParsingException("RightContext index must be non-negative in feature specification. ");
        }
        int tmpindex = 0;
        for (int i = this.right - 1; i > this.left; --i) {
            if (tmpindex == index) {
                return this.input.get(i);
            }
            ++tmpindex;
        }
        return null;
    }

    public DependencyNode getLeftTarget() {
        return this.input.get(this.left);
    }

    public DependencyNode getRightTarget() {
        return this.input.get(this.right);
    }

    @Override
    public void setDependencyGraph(DependencyStructure source) throws MaltChainedException {
        this.dependencyGraph.clear();
        Iterator<Object> i$ = source.getTokenIndices().iterator();
        while (i$.hasNext()) {
            int index = (Integer)i$.next();
            TokenNode gnode = source.getTokenNode(index);
            TokenNode pnode = this.dependencyGraph.addTokenNode(gnode.getIndex());
            for (SymbolTable table : gnode.getLabelTypes()) {
                pnode.addLabel(table, gnode.getLabelSymbol(table));
            }
            if (!gnode.hasHead()) continue;
            Edge s = gnode.getHeadEdge();
            Edge t = this.dependencyGraph.addDependencyEdge(s.getSource().getIndex(), s.getTarget().getIndex());
            for (SymbolTable table : s.getLabelTypes()) {
                t.addLabel(table, s.getLabelSymbol(table));
            }
        }
        for (SymbolTable table : source.getDefaultRootEdgeLabels().keySet()) {
            this.dependencyGraph.setDefaultRootEdgeLabel(table, source.getDefaultRootEdgeLabelSymbol(table));
        }
    }

    @Override
    public DependencyStructure getDependencyGraph() {
        return this.dependencyGraph;
    }

    @Override
    public void initialize(ParserConfiguration parserConfiguration) throws MaltChainedException {
        if (parserConfiguration != null) {
            UcovingtonConfig covingtonConfig = (UcovingtonConfig)parserConfiguration;
            ArrayList<DependencyNode> sourceInput = covingtonConfig.getInput();
            this.setDependencyGraph(covingtonConfig.getDependencyGraph());
            int n = sourceInput.size();
            for (int i = 0; i < n; ++i) {
                this.input.add(this.dependencyGraph.getDependencyNode(sourceInput.get(i).getIndex()));
            }
            this.left = covingtonConfig.getLeft();
            this.right = covingtonConfig.getRight();
            this.rightstop = covingtonConfig.getRightstop();
            this.leftstop = covingtonConfig.getLeftstop();
        } else {
            int n = this.dependencyGraph.getHighestTokenIndex();
            for (int i = 0; i <= n; ++i) {
                DependencyNode node = this.dependencyGraph.getDependencyNode(i);
                if (node == null) continue;
                this.input.add(node);
            }
            this.leftstop = this.allowRoot ? 0 : 1;
            this.rightstop = this.dependencyGraph.getHighestTokenIndex();
            this.left = this.leftstop;
            this.right = this.left + 1;
        }
    }

    @Override
    public void clear() throws MaltChainedException {
        this.dependencyGraph.clear();
        this.input.clear();
        this.historyNode = null;
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (this.getClass() != obj.getClass()) {
            return false;
        }
        UcovingtonConfig that = (UcovingtonConfig)obj;
        if (this.input.size() != that.getInput().size()) {
            return false;
        }
        if (this.dependencyGraph.nEdges() != that.getDependencyGraph().nEdges()) {
            return false;
        }
        for (int i = 0; i < this.input.size(); ++i) {
            if (this.input.get(i).getIndex() == that.getInput().get(i).getIndex()) continue;
            return false;
        }
        return this.dependencyGraph.getEdges().equals(that.getDependencyGraph().getEdges());
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append(this.input.size());
        sb.append(", ");
        sb.append(this.dependencyGraph.nEdges());
        return sb.toString();
    }

    private boolean hasAncestorInside1(DependencyNode node, int left, int right) throws MaltChainedException {
        DependencyNode tmp = node;
        return tmp.getHead() != null && (tmp = tmp.getHead()).getIndex() >= left && tmp.getIndex() <= right;
    }
}

