/*
 * Decompiled with CFR 0.152.
 */
package com.aliasi.tokenizer;

import com.aliasi.tokenizer.TokenCategorizer;
import com.aliasi.util.Strings;

public class CharacterTokenCategorizer
implements TokenCategorizer {
    public static final String UNKNOWN_CAT = "UNKNOWN";
    public static final String DIGIT_CAT = "DIGIT";
    public static final String LETTER_CAT = "LETTER";
    public static final String PUNCTUATION_CAT = "PUNCTUATION";
    public static final String OTHER_CAT = "OTHER";
    static final CharacterTokenCategorizer INSTANCE = new CharacterTokenCategorizer();
    private static final String[] CATEGORY_ARRAY = new String[]{"UNKNOWN", "DIGIT", "LETTER", "PUNCTUATION", "OTHER"};

    @Deprecated
    public CharacterTokenCategorizer() {
    }

    public String categorize(String token) {
        if (token.length() != 1) {
            return UNKNOWN_CAT;
        }
        char c = token.charAt(0);
        if (Character.isDigit(c)) {
            return DIGIT_CAT;
        }
        if (Character.isLetter(c)) {
            return LETTER_CAT;
        }
        if (Strings.isPunctuation(c)) {
            return PUNCTUATION_CAT;
        }
        return OTHER_CAT;
    }

    public String[] categories() {
        return (String[])CATEGORY_ARRAY.clone();
    }

    public String toString() {
        return this.getClass().getName();
    }
}

