/*
 * Decompiled with CFR 0.152.
 */
package com.aliasi.spell;

import com.aliasi.util.Distance;
import com.aliasi.util.Proximity;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class EditDistance
implements Distance<CharSequence>,
Proximity<CharSequence> {
    private final boolean mAllowTransposition;
    public static final Distance<CharSequence> TRANSPOSING = new EditDistance(true);
    public static final Distance<CharSequence> NON_TRANSPOSING = new EditDistance(false);

    public EditDistance(boolean allowTransposition) {
        this.mAllowTransposition = allowTransposition;
    }

    @Override
    public double distance(CharSequence cSeq1, CharSequence cSeq2) {
        return EditDistance.editDistance(cSeq1, cSeq2, this.mAllowTransposition);
    }

    @Override
    public double proximity(CharSequence cSeq1, CharSequence cSeq2) {
        return -this.distance(cSeq1, cSeq2);
    }

    public String toString() {
        return "EditDistance(" + this.mAllowTransposition + ")";
    }

    public static int editDistance(CharSequence cSeq1, CharSequence cSeq2, boolean allowTransposition) {
        if (cSeq1.length() < cSeq2.length()) {
            CharSequence temp = cSeq1;
            cSeq1 = cSeq2;
            cSeq2 = temp;
        }
        if (cSeq2.length() == 0) {
            return cSeq1.length();
        }
        if (cSeq2.length() == 1) {
            char c = cSeq2.charAt(0);
            for (int i = 0; i < cSeq1.length(); ++i) {
                if (cSeq1.charAt(i) != c) continue;
                return cSeq1.length() - 1;
            }
            return cSeq1.length();
        }
        if (allowTransposition) {
            return EditDistance.editDistanceTranspose(cSeq1, cSeq2);
        }
        return EditDistance.editDistanceNonTranspose(cSeq1, cSeq2);
    }

    private static int editDistanceNonTranspose(CharSequence cSeq1, CharSequence cSeq2) {
        int xsLength = cSeq1.length() + 1;
        int ysLength = cSeq2.length() + 1;
        int[] lastSlice = new int[ysLength];
        int[] currentSlice = new int[ysLength];
        for (int y = 0; y < ysLength; ++y) {
            currentSlice[y] = y;
        }
        for (int x = 1; x < xsLength; ++x) {
            char cX = cSeq1.charAt(x - 1);
            int[] lastSliceTmp = lastSlice;
            lastSlice = currentSlice;
            currentSlice = lastSliceTmp;
            currentSlice[0] = x;
            for (int y = 1; y < ysLength; ++y) {
                int yMinus1 = y - 1;
                currentSlice[y] = Math.min(cX == cSeq2.charAt(yMinus1) ? lastSlice[yMinus1] : 1 + lastSlice[yMinus1], 1 + Math.min(lastSlice[y], currentSlice[yMinus1]));
            }
        }
        return currentSlice[currentSlice.length - 1];
    }

    private static int editDistanceTranspose(CharSequence cSeq1, CharSequence cSeq2) {
        int xsLength = cSeq1.length() + 1;
        int ysLength = cSeq2.length() + 1;
        int[] twoLastSlice = new int[ysLength];
        int[] lastSlice = new int[ysLength];
        int[] currentSlice = new int[ysLength];
        for (int y = 0; y < ysLength; ++y) {
            lastSlice[y] = y;
        }
        currentSlice[0] = 1;
        char cX = cSeq1.charAt(0);
        for (int y = 1; y < ysLength; ++y) {
            int yMinus1 = y - 1;
            currentSlice[y] = Math.min(cX == cSeq2.charAt(yMinus1) ? lastSlice[yMinus1] : 1 + lastSlice[yMinus1], 1 + Math.min(lastSlice[y], currentSlice[yMinus1]));
        }
        char cYZero = cSeq2.charAt(0);
        for (int x = 2; x < xsLength; ++x) {
            char cXMinus1 = cX;
            cX = cSeq1.charAt(x - 1);
            int[] tmpSlice = twoLastSlice;
            twoLastSlice = lastSlice;
            lastSlice = currentSlice;
            currentSlice = tmpSlice;
            currentSlice[0] = x;
            currentSlice[1] = Math.min(cX == cYZero ? lastSlice[0] : 1 + lastSlice[0], 1 + Math.min(lastSlice[1], currentSlice[0]));
            char cY = cYZero;
            for (int y = 2; y < ysLength; ++y) {
                int yMinus1 = y - 1;
                char cYMinus1 = cY;
                cY = cSeq2.charAt(yMinus1);
                currentSlice[y] = Math.min(cX == cY ? lastSlice[yMinus1] : 1 + lastSlice[yMinus1], 1 + Math.min(lastSlice[y], currentSlice[yMinus1]));
                if (cX != cYMinus1 || cY != cXMinus1) continue;
                currentSlice[y] = Math.min(currentSlice[y], 1 + twoLastSlice[y - 2]);
            }
        }
        return currentSlice[currentSlice.length - 1];
    }
}

