/*
 * Decompiled with CFR 0.152.
 */
package similarity;

import com.aliasi.tokenizer.Tokenizer;
import com.aliasi.tokenizer.TokenizerFactory;
import java.io.File;
import java.util.ArrayList;
import java.util.Set;
import java.util.TreeMap;
import segmenter.IDataSource;
import segmenter.TextFileIO;

public class TokenDictionary {
    File inputFile;
    String textString = null;
    TokenizerFactory tokenFactory;
    private TreeMap<String, Integer> tokenToIdMap = null;
    private TreeMap<Integer, String> idToTokenMap = null;
    private int tokenTypeCounter = 0;

    public TokenDictionary(File file, TokenizerFactory tokenizerFactory) {
        this.inputFile = file;
        this.tokenFactory = tokenizerFactory;
        this.tokenToIdMap = new TreeMap();
        this.idToTokenMap = new TreeMap();
    }

    public TokenDictionary(IDataSource iDataSource, TokenizerFactory tokenizerFactory) {
        this.inputFile = null;
        StringBuilder stringBuilder = new StringBuilder();
        for (int i = 0; i < iDataSource.GetNumChunks(); ++i) {
            stringBuilder.append(" " + iDataSource.GetChunk(i) + " ");
        }
        this.textString = stringBuilder.toString();
        this.tokenFactory = tokenizerFactory;
        this.tokenToIdMap = new TreeMap();
        this.idToTokenMap = new TreeMap();
    }

    public TokenDictionary(String string, TokenizerFactory tokenizerFactory) {
        this.inputFile = null;
        this.textString = string;
        this.tokenFactory = tokenizerFactory;
        this.tokenToIdMap = new TreeMap();
        this.idToTokenMap = new TreeMap();
    }

    public void ProcessText() {
        String string = this.inputFile != null ? TextFileIO.ReadTextFile(this.inputFile) : this.textString;
        try {
            String string2;
            Tokenizer tokenizer = this.tokenFactory.tokenizer(string.toCharArray(), 0, string.length());
            while ((string2 = tokenizer.nextToken()) != null) {
                if (this.tokenToIdMap.keySet().contains(string2)) continue;
                Integer n = new Integer(this.getTokenTypeCounter());
                this.tokenToIdMap.put(string2, n);
                this.idToTokenMap.put(n, string2);
                this.incrementTokenTypeCounter(this.tokenTypeCounter);
            }
        }
        catch (Exception exception) {
            System.out.println("Exception in TokenDictionary.ProcessText: " + exception.getMessage());
        }
    }

    public void AddText(String string) {
        try {
            String string2;
            Tokenizer tokenizer = this.tokenFactory.tokenizer(string.toCharArray(), 0, string.length());
            while ((string2 = tokenizer.nextToken()) != null) {
                if (this.tokenToIdMap.keySet().contains(string2)) continue;
                Integer n = new Integer(this.getTokenTypeCounter());
                this.tokenToIdMap.put(string2, n);
                this.idToTokenMap.put(n, string2);
                this.incrementTokenTypeCounter(this.tokenTypeCounter);
            }
        }
        catch (Exception exception) {
            System.out.println("Exception in TokenDictionary.ProcessText: " + exception.getMessage());
        }
    }

    public ArrayList<String> tokenize(String string) {
        ArrayList<String> arrayList = new ArrayList<String>();
        Tokenizer tokenizer = this.tokenFactory.tokenizer(string.toCharArray(), 0, string.length());
        try {
            String string2;
            while ((string2 = tokenizer.nextToken()) != null) {
                arrayList.add(string2);
            }
        }
        catch (Exception exception) {
            System.out.println("Exception in TokenDictionary.tokenize: " + exception.getMessage());
        }
        return arrayList;
    }

    public Integer GetTokenId(String string) {
        return this.tokenToIdMap.get(string);
    }

    public String GetTokenString(Integer n) {
        return this.idToTokenMap.get(n);
    }

    public int getTokenTypeCounter() {
        return this.tokenTypeCounter;
    }

    private void incrementTokenTypeCounter(int n) {
        ++this.tokenTypeCounter;
    }

    public int GetDictDimensions() {
        return this.tokenToIdMap.size();
    }

    public Set<Integer> GetAllTokenIds() {
        return this.idToTokenMap.keySet();
    }

    public Set<String> GetAllTokenStrings() {
        return this.tokenToIdMap.keySet();
    }

    public void PrintDictionary() {
        for (Integer n : this.idToTokenMap.keySet()) {
            String string = this.idToTokenMap.get(n);
            Integer n2 = this.tokenToIdMap.get(string);
            System.out.println(n.toString() + "\t" + string + "\t" + n2.toString());
            if (n <= 10) continue;
            break;
        }
    }
}

