/*
 * Decompiled with CFR 0.152.
 */
package com.aliasi.classify;

import com.aliasi.classify.ConditionalClassification;
import com.aliasi.util.Pair;

public class JointClassification
extends ConditionalClassification {
    private final double[] mLogJointProbs;

    public JointClassification(String[] categories, double[] log2JointProbs) {
        this(categories, log2JointProbs, log2JointProbs);
    }

    JointClassification(String[] categories, double[] condProbs, double[] log2JointProbs, double tolerance) {
        super(categories, condProbs, tolerance);
        this.mLogJointProbs = log2JointProbs;
    }

    public JointClassification(String[] categories, double[] scores, double[] log2JointProbs) {
        super(categories, scores, JointClassification.logJointToConditional(log2JointProbs), Double.POSITIVE_INFINITY);
        this.mLogJointProbs = log2JointProbs;
    }

    public double jointLog2Probability(int rank) {
        return rank >= this.mLogJointProbs.length ? Double.NEGATIVE_INFINITY : this.mLogJointProbs[rank];
    }

    public double score(int rank) {
        return super.score(rank);
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append("Rank  Category  Score  P(Category|Input)   log2 P(Category,Input)\n");
        for (int i = 0; i < this.size(); ++i) {
            sb.append(i + "=" + this.category(i) + " " + this.score(i) + " " + this.conditionalProbability(i) + " " + this.jointLog2Probability(i) + '\n');
        }
        return sb.toString();
    }

    public static JointClassification create(String[] categories, double[] logProbabilities) {
        JointClassification.verifyLengths(categories, logProbabilities);
        JointClassification.verifyLogProbs(logProbabilities);
        Pair<String[], double[]> catsProbs = JointClassification.sort(categories, logProbabilities);
        return new JointClassification(catsProbs.a(), catsProbs.b());
    }
}

