/*
 * Decompiled with CFR 0.152.
 */
package tsg.kernels;

import java.io.BufferedWriter;
import java.io.IOException;
import java.util.ArrayList;
import java.util.BitSet;
import java.util.Hashtable;
import java.util.ListIterator;
import java.util.Map;
import kernels.NodeSetCollectorMUB;
import kernels.NodeSetCollectorSimple;
import tsg.TSNodeLabel;
import tsg.TSNodeLabelIndex;
import tsg.TSNodeLabelStructure;
import tsg.kernels.CommonStructures;
import tsg.kernels.CommonSubBranch;

public class CommonSubBranchMUBFreqThreads
extends CommonSubBranch {
    public CommonSubBranchMUBFreqThreads(ArrayList<TSNodeLabelStructure> treebank, int threads, int startIndex) {
        super(treebank, threads, startIndex);
    }

    @Override
    protected void initiateThreadArray() {
        this.threadsArray = new CountFragmentsThread[this.threads];
        int i = 0;
        while (i < this.threads) {
            this.threadsArray[i] = new CountFragmentsThread();
            ++i;
        }
    }

    public static void main(String[] args) throws Exception {
    }

    private class CountFragmentsThread
    extends CommonStructures.CommonStructuresThread {
        Hashtable<TSNodeLabel, int[]> freqTable = new Hashtable();

        @Override
        protected void collectCommonFragments(TSNodeLabelStructure[] trees) {
            TSNodeLabelStructure[] tSNodeLabelStructureArray = trees;
            int n = trees.length;
            int n2 = 0;
            while (n2 < n) {
                TSNodeLabelStructure t1 = tSNodeLabelStructureArray[n2];
                if (t1 == null) break;
                this.startIndex[0] = this.startIndex[0] + 1;
                ListIterator iter = CommonSubBranchMUBFreqThreads.this.treebank.listIterator(this.startIndex[0]);
                NodeSetCollectorSimple intermediateCollector = new NodeSetCollectorSimple();
                while (iter.hasNext()) {
                    TSNodeLabelStructure t2 = (TSNodeLabelStructure)iter.next();
                    NodeSetCollectorMUB[][] CST = CommonSubBranchMUBFreqThreads.getCST(t1, t2);
                    CommonSubBranchMUBFreqThreads.extractSubTreesIntermediate(CST, intermediateCollector);
                }
                this.extractSubBranchesInTableThread(intermediateCollector, t1);
                ++n2;
            }
        }

        private void extractSubBranchesInTableThread(NodeSetCollectorSimple intermediateCollector, TSNodeLabelStructure s) {
            for (BitSet bs : intermediateCollector.bitSetSet) {
                TSNodeLabelIndex rootNode = s.structure[bs.nextSetBit(0)];
                TSNodeLabel fragment = rootNode.getSubBranch(bs);
                this.addThread(fragment);
            }
        }

        private void addThread(TSNodeLabel fragment) {
            int[] freq = this.freqTable.get(fragment);
            if (freq == null) {
                this.freqTable.put(fragment, new int[]{1});
            } else {
                freq[0] = freq[0] + 1;
            }
        }

        @Override
        protected void printFragmentsToFile(BufferedWriter fileWriter) throws IOException {
            for (Map.Entry<TSNodeLabel, int[]> e : this.freqTable.entrySet()) {
                TSNodeLabel fragment = e.getKey();
                int freq = e.getValue()[0];
                String fragmetnFreqString = String.valueOf(fragment.toString(false, true)) + "\t" + freq;
                fileWriter.write(String.valueOf(fragmetnFreqString) + "\n");
            }
        }

        @Override
        protected void clearFragmentBank() {
            this.freqTable.clear();
        }
    }
}

