/*
 * Decompiled with CFR 0.152.
 */
package tsg.parser;

import java.io.File;
import java.io.FileInputStream;
import java.io.FileOutputStream;
import java.io.ObjectInputStream;
import java.io.ObjectOutputStream;
import java.io.Serializable;
import java.util.ArrayList;
import java.util.Hashtable;
import java.util.Iterator;
import java.util.ListIterator;
import java.util.SortedSet;
import java.util.TreeSet;
import tsg.parser.DerivationForest;
import tsg.parser.Grammar;
import util.FileUtil;

public class Cell
implements Serializable {
    private static final long serialVersionUID = 0L;
    static Grammar grammar;
    Hashtable<Integer, DerivationForest> DerivationForestSet = new Hashtable();
    TreeSet<Integer> possibleRoots = new TreeSet();
    ArrayList<Integer> yield;

    public Cell() {
        this.yield = new ArrayList();
    }

    public Cell(ArrayList<Integer> yield) {
        this.yield = yield;
    }

    public Cell(Integer word) {
        this();
        this.yield.add(word);
        int[] possibleRules = Cell.grammar.rulesOfWord[word];
        int i = 0;
        while (i < possibleRules.length) {
            int lexRuleIndex = possibleRules[i];
            int root = Cell.grammar.lexRules[lexRuleIndex][0];
            this.possibleRoots.add(root);
            DerivationForest forest = new DerivationForest(root, Cell.grammar.lexLogProb[lexRuleIndex]);
            this.DerivationForestSet.put(root, forest);
            ++i;
        }
    }

    public String getYieldInWord() {
        String result = "";
        ListIterator<Integer> i = this.yield.listIterator();
        while (i.hasNext()) {
            String word = Cell.grammar.lexArray[i.next()];
            result = String.valueOf(result) + word + " ";
        }
        return result.trim();
    }

    public void updateBinary(Cell leftCell, Cell upCell, int split) {
        for (int leftRoot : leftCell.possibleRoots) {
            int[] applicableRules = Cell.grammar.binaryRulesOfLeftChild[leftRoot];
            if (applicableRules == null) continue;
            int k = 0;
            while (k < applicableRules.length) {
                int ruleIndex = applicableRules[k];
                int[] rule = Cell.grammar.intBinaryRules[ruleIndex];
                int upRoot = rule[2];
                int parentRoot = rule[0];
                if (upCell.possibleRoots.contains(upRoot)) {
                    double ruleLogProb = Cell.grammar.intBinaryLogProb[ruleIndex];
                    boolean newEntry = this.possibleRoots.add(parentRoot);
                    DerivationForest leftForest = leftCell.DerivationForestSet.get(leftRoot);
                    DerivationForest upForest = upCell.DerivationForestSet.get(upRoot);
                    if (newEntry) {
                        DerivationForest newForest = new DerivationForest(parentRoot, leftForest, upForest, split, ruleLogProb);
                        this.DerivationForestSet.put(parentRoot, newForest);
                    } else {
                        DerivationForest updatingForest = this.DerivationForestSet.get(parentRoot);
                        updatingForest.updateForest(leftForest, upForest, split, ruleLogProb);
                    }
                }
                ++k;
            }
        }
    }

    public void updateUnary() {
        TreeSet<Integer> initialRoots = new TreeSet<Integer>((SortedSet<Integer>)this.possibleRoots);
        for (Integer root : initialRoots) {
            this.updateUnary(root);
        }
    }

    public void updateUnary(Integer root) {
        int[] applicableRules = Cell.grammar.unaryRulesOfLeftChild[root];
        if (applicableRules == null) {
            return;
        }
        DerivationForest rootForest = this.DerivationForestSet.get(root);
        int k = 0;
        while (k < applicableRules.length) {
            int ruleIndex = applicableRules[k];
            int[] rule = Cell.grammar.intUnaryRules[ruleIndex];
            double ruleLogProb = Cell.grammar.intUnaryLogProb[ruleIndex];
            int parentRoot = rule[0];
            if (rule[0] != rule[1]) {
                this.updateUnary(parentRoot, rootForest, ruleLogProb);
            }
            ++k;
        }
    }

    public boolean updateUnary(int parentRoot, DerivationForest rootForest, double ruleLogProb) {
        boolean newEntry = this.possibleRoots.add(parentRoot);
        if (newEntry) {
            DerivationForest newForest = new DerivationForest(parentRoot, rootForest, ruleLogProb);
            this.DerivationForestSet.put(parentRoot, newForest);
            return true;
        }
        DerivationForest updatingForest = this.DerivationForestSet.get(parentRoot);
        return updatingForest.updateForest(rootForest, ruleLogProb);
    }

    public void updateUnaryOld() {
        TreeSet<Integer> parentRoots = new TreeSet<Integer>();
        TreeSet<Integer> uniqueChildren = new TreeSet<Integer>();
        TreeSet<Integer> ruleIndexes = new TreeSet<Integer>();
        for (int uniqueChild : this.possibleRoots) {
            int[] applicableRules = Cell.grammar.unaryRulesOfLeftChild[uniqueChild];
            if (applicableRules == null) continue;
            int k = 0;
            while (k < applicableRules.length) {
                int ruleIndex = applicableRules[k];
                int[] rule = Cell.grammar.intUnaryRules[ruleIndex];
                int parentRoot = rule[0];
                if (parentRoot != uniqueChild) {
                    ruleIndexes.add(ruleIndex);
                    parentRoots.add(parentRoot);
                    uniqueChildren.add(uniqueChild);
                }
                ++k;
            }
        }
        TreeSet parentRootsProblems = new TreeSet(parentRoots);
        TreeSet parentRootsNoProblems = new TreeSet(parentRoots);
        parentRootsProblems.retainAll(this.possibleRoots);
        parentRootsNoProblems.removeAll(parentRootsProblems);
        if (!parentRootsProblems.isEmpty()) {
            System.out.print("");
        }
        int round = 0;
        while (round < 2) {
            Iterator j = uniqueChildren.iterator();
            while (j.hasNext()) {
                int uniqueChild = (Integer)j.next();
                int[] applicableRules = Cell.grammar.unaryRulesOfLeftChild[uniqueChild];
                if (applicableRules == null) continue;
                int k = 0;
                while (k < applicableRules.length) {
                    int ruleIndex = applicableRules[k];
                    int[] rule = Cell.grammar.intUnaryRules[ruleIndex];
                    int parentRoot = rule[0];
                    if (!(parentRoot == uniqueChild || !parentRootsProblems.contains(parentRoot) && round == 0 || parentRootsProblems.contains(parentRoot) && round == 1)) {
                        double ruleLogProb = Cell.grammar.intUnaryLogProb[ruleIndex];
                        boolean newEntry = this.possibleRoots.add(parentRoot);
                        DerivationForest uniqueChildForest = this.DerivationForestSet.get(uniqueChild);
                        if (newEntry) {
                            DerivationForest newForest = new DerivationForest(parentRoot, uniqueChildForest, ruleLogProb);
                            this.DerivationForestSet.put(parentRoot, newForest);
                        } else {
                            DerivationForest updatingForest = this.DerivationForestSet.get(parentRoot);
                            updatingForest.updateForest(uniqueChildForest, ruleLogProb);
                        }
                    }
                    ++k;
                }
            }
            ++round;
        }
    }

    public static Cell fromBinaryFile(File inputFile) {
        try {
            ObjectInputStream in = new ObjectInputStream(new FileInputStream(inputFile));
            return (Cell)in.readObject();
        }
        catch (Exception e) {
            FileUtil.handleExceptions(e);
            return null;
        }
    }

    public void toBinaryFile(File outputFile) {
        try {
            ObjectOutputStream out = new ObjectOutputStream(new FileOutputStream(outputFile));
            out.writeObject(this);
        }
        catch (Exception e) {
            FileUtil.handleExceptions(e);
        }
    }
}

