/*
 * Decompiled with CFR 0.152.
 */
package tsg.kernels;

import java.io.File;
import java.io.FileWriter;
import java.io.IOException;
import java.io.PrintWriter;
import java.io.Writer;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Scanner;
import java.util.concurrent.PriorityBlockingQueue;
import settings.Parameters;
import tsg.TSNodeLabel;
import tsg.corpora.Wsj;
import tsg.kernels.RetrieveCorrectFreq;
import util.ArgumentReader;
import util.FileUtil;
import util.PrintProgress;
import util.StringLong;

public class RetrieveCorrectFreqQueue
extends RetrieveCorrectFreq {
    public static int numberOfFragmentsPerThreads = 500;
    public static int printProgressEvery = 10000;
    Scanner fragmentScanner;
    Writer fragmentWriter;
    long fragmentReadCounter;
    long fragmentWrittenCounter;
    PriorityBlockingQueue<StringLong> fragmentsWaitingToBeWritten;
    long currentIndex;
    PrintProgress progress;

    public RetrieveCorrectFreqQueue(ArrayList<TSNodeLabel> treebank, File fragmentsFile, File outputFile, boolean partialFragments, int threads) {
        super(treebank, fragmentsFile, outputFile, partialFragments, threads);
        this.fragmentScanner = FileUtil.getScanner(fragmentsFile);
    }

    @Override
    public void retriveCorrectFreqResume() {
        Parameters.reportLineFlush("Retrieving Correct Frequencies Resuming from existing file");
        Scanner scanOutput = FileUtil.getScanner(this.outputFile);
        File tempFile = new File(String.valueOf(this.outputFile.getAbsolutePath()) + ".tmp");
        this.progress = new PrintProgress("Reading already counted fragments", printProgressEvery, 0);
        String lineOutput = null;
        String lineInput = null;
        if (scanOutput.hasNextLine()) {
            String[] lineOutputSplit;
            lineInput = this.fragmentScanner.nextLine();
            lineOutput = scanOutput.nextLine();
            String[] lineInputSplit = lineInput.split("\t");
            if (!lineInputSplit[0].equals((lineOutputSplit = lineOutput.split("\t"))[0]) || lineOutputSplit.length < 2) {
                Parameters.reportError("Cannot resume files, the two files don't match in the first line!");
                return;
            }
        } else {
            Parameters.reportLineFlush("Empty File, rewriting on it...");
            this.retriveCorrectFreq();
            return;
        }
        PrintWriter pw = null;
        try {
            pw = new PrintWriter(new FileWriter(tempFile));
        }
        catch (IOException e) {
            e.printStackTrace();
            return;
        }
        int countLine = 1;
        while (scanOutput.hasNextLine()) {
            ++countLine;
            pw.println(lineOutput);
            lineInput = this.fragmentScanner.nextLine();
            lineOutput = scanOutput.nextLine();
        }
        this.progress.end();
        scanOutput.close();
        pw.close();
        if (!this.outputFile.delete()) {
            Parameters.reportError("Could not delete file");
            return;
        }
        if (!tempFile.renameTo(this.outputFile)) {
            Parameters.reportError("Could not rename file");
            return;
        }
        try {
            this.fragmentWriter = new FileWriter(this.outputFile, true);
        }
        catch (IOException e) {
            e.printStackTrace();
            return;
        }
        String[] lineSplit = lineInput.split("\t");
        TSNodeLabel fragment = null;
        try {
            fragment = new TSNodeLabel(lineSplit[0], false);
        }
        catch (Exception e) {
            e.printStackTrace();
            return;
        }
        long count = this.partialFragments ? TSNodeLabel.countPartialFragmentInTreebank(this.treebank, fragment) : (long)TSNodeLabel.countFragmentInTreebank(this.treebank, fragment);
        try {
            this.fragmentWriter.write(String.valueOf(fragment.toString(false, true)) + "\t" + count + "\n");
        }
        catch (IOException e) {
            e.printStackTrace();
            return;
        }
        Parameters.reportLineFlush("Retrieving Correct Frequencies of remaining fragments");
        this.progress = new PrintProgress("Extracting from tree:", printProgressEvery, 0);
        try {
            if (this.threads == 1) {
                this.processInputOutputSingleThread();
            } else {
                this.processInputOutputMultipleThreads();
            }
        }
        catch (Exception e) {
            e.printStackTrace();
            return;
        }
        this.progress.end();
    }

    @Override
    public void retriveCorrectFreq() {
        this.fragmentWriter = FileUtil.getPrintWriter(this.outputFile);
        Parameters.reportLineFlush("Retrieving Correct Frequencies");
        this.progress = new PrintProgress("Extracting from tree:", printProgressEvery, 0);
        try {
            if (this.threads == 1) {
                this.processInputOutputSingleThread();
            } else {
                this.processInputOutputMultipleThreads();
            }
        }
        catch (Exception e) {
            e.printStackTrace();
            return;
        }
        this.progress.end();
    }

    private void processInputOutputSingleThread() throws Exception {
        if (this.partialFragments) {
            this.processInputOutputSingleThreadPartialFragments();
        } else {
            this.processInputOutputSingleThreadFragments();
        }
    }

    private void processInputOutputSingleThreadFragments() throws Exception {
        while (this.fragmentScanner.hasNextLine()) {
            this.progress.next();
            String line = this.fragmentScanner.nextLine();
            if (line.equals("")) continue;
            String[] lineSplit = line.split("\t");
            TSNodeLabel fragment = new TSNodeLabel(lineSplit[0], false);
            long count = TSNodeLabel.countFragmentInTreebank(this.treebank, fragment);
            this.fragmentWriter.write(String.valueOf(fragment.toString(false, true)) + "\t" + count + "\n");
        }
    }

    private void processInputOutputSingleThreadPartialFragments() throws Exception {
        while (this.fragmentScanner.hasNextLine()) {
            this.progress.next();
            String line = this.fragmentScanner.nextLine();
            if (line.equals("")) continue;
            String[] lineSplit = line.split("\t");
            TSNodeLabel fragment = new TSNodeLabel(lineSplit[0], false);
            long count = TSNodeLabel.countPartialFragmentInTreebank(this.treebank, fragment);
            this.fragmentWriter.write(String.valueOf(fragment.toString(false, true)) + "\t" + count + "\n");
        }
    }

    private synchronized long getNextFragmentsLoad(TSNodeLabel[] fragmentsForThread) {
        Arrays.fill(fragmentsForThread, null);
        boolean filled = this.fragmentScanner.hasNextLine();
        int i = 0;
        while (this.fragmentScanner.hasNextLine()) {
            if (i == numberOfFragmentsPerThreads) break;
            String line = this.fragmentScanner.nextLine();
            String[] lineSplit = line.split("\t");
            try {
                fragmentsForThread[i] = new TSNodeLabel(lineSplit[0], false);
            }
            catch (Exception e) {
                e.printStackTrace();
            }
            ++i;
        }
        if (filled) {
            this.progress.next(i);
            long index = this.fragmentReadCounter;
            this.fragmentReadCounter += (long)i;
            return index;
        }
        return -1L;
    }

    private synchronized void addFragmentsToQueue(TSNodeLabel[] currentFragments, long firstFragmentIndex, long[] fragmentsCounts) throws IOException {
        if (firstFragmentIndex == this.fragmentWrittenCounter) {
            int i = 0;
            while (i < numberOfFragmentsPerThreads) {
                TSNodeLabel currentFragment = currentFragments[i];
                if (currentFragment == null) break;
                String newFragmentCount = String.valueOf(currentFragment.toString(false, true)) + "\t" + fragmentsCounts[i] + "\n";
                this.fragmentWriter.write(newFragmentCount);
                ++i;
            }
            this.fragmentWrittenCounter += (long)i;
            while (!this.fragmentsWaitingToBeWritten.isEmpty()) {
                StringLong nextElement = this.fragmentsWaitingToBeWritten.peek();
                long position = nextElement.getLongInteger();
                if (position == this.fragmentWrittenCounter) {
                    this.fragmentWriter.write(nextElement.getString());
                    this.fragmentsWaitingToBeWritten.poll();
                    ++this.fragmentWrittenCounter;
                    continue;
                }
                break;
            }
        } else {
            int i = 0;
            while (i < numberOfFragmentsPerThreads) {
                TSNodeLabel currentFragment = currentFragments[i];
                if (currentFragment != null) {
                    String newFragmentCount = String.valueOf(currentFragment.toString(false, true)) + "\t" + fragmentsCounts[i] + "\n";
                    StringLong stringToQueue = new StringLong(newFragmentCount, firstFragmentIndex + (long)i);
                    this.fragmentsWaitingToBeWritten.add(stringToQueue);
                    ++i;
                    continue;
                }
                break;
            }
        }
    }

    private void processInputOutputMultipleThreads() throws Exception {
        this.fragmentsWaitingToBeWritten = new PriorityBlockingQueue();
        CountFragmentsThread[] threadsArray = new CountFragmentsThread[this.threads];
        int lastThreadIndex = this.threads - 1;
        int t = 0;
        while (t < this.threads) {
            CountFragmentsThread newCounterThread;
            threadsArray[t] = newCounterThread = this.partialFragments ? new CountPartialFragmentsThread() : new CountFragmentsThread();
            if (t == lastThreadIndex) {
                newCounterThread.run();
            } else {
                newCounterThread.start();
            }
            ++t;
        }
        int i = 0;
        while (i < lastThreadIndex) {
            try {
                threadsArray[i].join();
            }
            catch (InterruptedException e) {
                e.printStackTrace();
            }
            ++i;
        }
        this.fragmentScanner.close();
        this.fragmentWriter.close();
    }

    public static void main2(String[] args) throws Exception {
        File treebankFile = new File("/scratch/fsangati/CORPUS/FrenchTreebank/ftbuc+lexeme-only/ftb_1_cleaned.mrg");
        ArrayList<TSNodeLabel> treebank = Wsj.getTreebank(treebankFile);
        for (TSNodeLabel t : treebank) {
            ArrayList<TSNodeLabel> nodes = t.collectAllNodes();
            for (TSNodeLabel n : nodes) {
                if (n.label != null) continue;
                System.out.println(t);
            }
        }
    }

    public static void main1(String[] args) throws Exception {
        RetrieveCorrectFreqQueue.main1(new String[]{"-threads:2", "/Users/fedja/Work/Code/TreeGrammars/tmp/wsj-02-21_uk1.mrg", "/Users/fedja/Work/Code/TreeGrammars/tmp/fragments_exactFreq_uk1_shuffled_first233.txt", "/Users/fedja/Work/Code/TreeGrammars/tmp/fragments_exactFreq_uk1_shuffled_first233_new.txt"});
    }

    public static void main(String[] args) throws Exception {
        long time = System.currentTimeMillis();
        String usage = "USAGE: java RetrieveCorrectFreq [-partialFragments:false] [-threads:1] treebank inputFile outputFile";
        String partialFragmentsOption = "-partialFragments:";
        String threadsOption = "-threads:";
        int threads = 1;
        boolean partialFragments = false;
        int length = args.length;
        if (length < 3 || length > 5) {
            System.err.println("Incorrect number of arguments");
            System.err.println(usage);
            return;
        }
        File treebankFile = null;
        File inputFile = null;
        File outputFile = null;
        String[] stringArray = args;
        int n = args.length;
        int n2 = 0;
        while (n2 < n) {
            String option = stringArray[n2];
            if (option.equals(partialFragmentsOption)) {
                partialFragments = ArgumentReader.readBooleanOption(option);
            } else if (option.startsWith(threadsOption)) {
                threads = ArgumentReader.readIntOption(option);
            } else if (treebankFile == null) {
                treebankFile = new File(option);
            } else if (inputFile == null) {
                inputFile = new File(option);
            } else {
                outputFile = new File(option);
            }
            ++n2;
        }
        if (!treebankFile.exists()) {
            System.err.println("Treebank File does not exist");
            System.err.println(usage);
            return;
        }
        if (!inputFile.exists()) {
            System.err.println("Input File does not exist");
            System.err.println(usage);
            return;
        }
        ArrayList<TSNodeLabel> treebank = Wsj.getTreebank(treebankFile);
        RetrieveCorrectFreqQueue RCF = new RetrieveCorrectFreqQueue(treebank, inputFile, outputFile, partialFragments, threads);
        RCF.run();
        System.out.println("Took: " + (System.currentTimeMillis() - time) / 1000L + "seconds.");
    }

    private class CountFragmentsThread
    extends Thread {
        TSNodeLabel[] currentFragments = new TSNodeLabel[numberOfFragmentsPerThreads];
        long loadFirstIndex;
        long[] fragmentsCounts = new long[numberOfFragmentsPerThreads];

        @Override
        public void run() {
            while ((this.loadFirstIndex = RetrieveCorrectFreqQueue.this.getNextFragmentsLoad(this.currentFragments)) != -1L) {
                int i = 0;
                while (i < numberOfFragmentsPerThreads) {
                    TSNodeLabel currentFragment = this.currentFragments[i];
                    if (currentFragment == null) break;
                    this.fragmentsCounts[i] = this.getCount(currentFragment);
                    ++i;
                }
                try {
                    RetrieveCorrectFreqQueue.this.addFragmentsToQueue(this.currentFragments, this.loadFirstIndex, this.fragmentsCounts);
                }
                catch (IOException e) {
                    Parameters.reportError(e.getMessage());
                    e.printStackTrace();
                    return;
                }
            }
        }

        protected long getCount(TSNodeLabel currentFragment) {
            return TSNodeLabel.countFragmentInTreebank(RetrieveCorrectFreqQueue.this.treebank, currentFragment);
        }
    }

    private class CountPartialFragmentsThread
    extends CountFragmentsThread {
        private CountPartialFragmentsThread() {
        }

        @Override
        protected long getCount(TSNodeLabel currentFragment) {
            return TSNodeLabel.countPartialFragmentInTreebank(RetrieveCorrectFreqQueue.this.treebank, currentFragment);
        }
    }
}

