import argparse
from utils.trans_to_vicuna_format import trans_to_vicuna_format


def parse_arguments():
    """
    Parse command-line input arguments.

    Returns:
        argparse.Namespace: A namespace of command-line arguments, containing input and output file paths.
    """
    parser = argparse.ArgumentParser(description="=Trans data to training format.")
    parser.add_argument("input_file", help="Input JSON file path")
    parser.add_argument("output_file", help="Output JSON file path")
    return parser.parse_args()


def main():
    """main"""
    args = parse_arguments()
    trans_to_vicuna_format(args)


if __name__ == '__main__':
    main()
