/*
 * Decompiled with CFR 0.152.
 */
package edu.stanford.nlp.sequences;

import edu.stanford.nlp.sequences.BestSequenceFinder;
import edu.stanford.nlp.sequences.SequenceModel;
import edu.stanford.nlp.stats.ClassicCounter;
import edu.stanford.nlp.stats.Counters;
import java.util.Arrays;

public class KBestSequenceFinder
implements BestSequenceFinder {
    @Override
    public int[] bestSequence(SequenceModel ts) {
        return Counters.argmax(this.kBestSequences(ts, 1));
    }

    public ClassicCounter<int[]> kBestSequences(SequenceModel ts, int k) {
        int k1;
        int predProduct;
        int newTagNum;
        int factor;
        int sharedProduct;
        int product;
        int pos;
        int length = ts.length();
        int leftWindow = ts.leftWindow();
        int rightWindow = ts.rightWindow();
        assert (rightWindow == 0);
        int padLength = length + leftWindow + rightWindow;
        int[][] tags = new int[padLength][];
        int[] tagNum = new int[padLength];
        for (int pos2 = 0; pos2 < padLength; ++pos2) {
            tags[pos2] = ts.getPossibleValues(pos2);
            tagNum[pos2] = tags[pos2].length;
        }
        int[] tempTags = new int[padLength];
        int[] productSizes = new int[padLength];
        int curProduct = 1;
        for (int i = 0; i < leftWindow; ++i) {
            curProduct *= tagNum[i];
        }
        for (int pos3 = leftWindow; pos3 < padLength; ++pos3) {
            if (pos3 > leftWindow + rightWindow) {
                curProduct /= tagNum[pos3 - leftWindow - rightWindow - 1];
            }
            productSizes[pos3 - rightWindow] = curProduct *= tagNum[pos3];
        }
        double[][] windowScore = new double[padLength][];
        for (int pos4 = leftWindow; pos4 < leftWindow + length; ++pos4) {
            windowScore[pos4] = new double[productSizes[pos4]];
            Arrays.fill(tempTags, tags[0][0]);
            for (int product2 = 0; product2 < productSizes[pos4]; ++product2) {
                int p = product2;
                int shift = 1;
                for (int curPos = pos4; curPos >= pos4 - leftWindow; --curPos) {
                    tempTags[curPos] = tags[curPos][p % tagNum[curPos]];
                    p /= tagNum[curPos];
                    if (curPos <= pos4) continue;
                    shift *= tagNum[curPos];
                }
                if (tempTags[pos4] != tags[pos4][0]) continue;
                double[] scores = ts.scoresOf(tempTags, pos4);
                for (int t = 0; t < tagNum[pos4]; ++t) {
                    windowScore[pos4][product2 + t * shift] = scores[t];
                }
            }
        }
        double[][][] score = new double[padLength][][];
        int[][][][] trace = new int[padLength][][][];
        int[][] numWaysToMake = new int[padLength][];
        for (pos = 0; pos < padLength; ++pos) {
            score[pos] = new double[productSizes[pos]][];
            trace[pos] = new int[productSizes[pos]][][];
            numWaysToMake[pos] = new int[productSizes[pos]];
            Arrays.fill(numWaysToMake[pos], 1);
            for (product = 0; product < productSizes[pos]; ++product) {
                if (pos == leftWindow) {
                    numWaysToMake[pos][product] = 1;
                } else if (pos > leftWindow) {
                    sharedProduct = product / tagNum[pos];
                    factor = productSizes[pos] / tagNum[pos];
                    numWaysToMake[pos][product] = 0;
                    for (newTagNum = 0; newTagNum < tagNum[pos - leftWindow - 1]; ++newTagNum) {
                        predProduct = newTagNum * factor + sharedProduct;
                        int[] nArray = numWaysToMake[pos];
                        int n = product;
                        nArray[n] = nArray[n] + numWaysToMake[pos - 1][predProduct];
                    }
                    if (numWaysToMake[pos][product] > k) {
                        numWaysToMake[pos][product] = k;
                    }
                } else {
                    numWaysToMake[pos][product] = 1;
                }
                score[pos][product] = new double[numWaysToMake[pos][product]];
                trace[pos][product] = new int[numWaysToMake[pos][product]][2];
            }
        }
        for (pos = leftWindow; pos < length + leftWindow; ++pos) {
            for (product = 0; product < productSizes[pos]; ++product) {
                if (pos == leftWindow) {
                    score[pos][product][0] = windowScore[pos][product];
                    trace[pos][product][0][0] = -1;
                    trace[pos][product][0][1] = -1;
                    continue;
                }
                for (int k12 = 0; k12 < score[pos][product].length; ++k12) {
                    score[pos][product][k12] = Double.NEGATIVE_INFINITY;
                    trace[pos][product][k12][0] = -1;
                    trace[pos][product][k12][1] = -1;
                }
                sharedProduct = product / tagNum[pos + rightWindow];
                factor = productSizes[pos] / tagNum[pos + rightWindow];
                for (newTagNum = 0; newTagNum < tagNum[pos - leftWindow - 1]; ++newTagNum) {
                    predProduct = newTagNum * factor + sharedProduct;
                    block14: for (k1 = 0; k1 < score[pos - 1][predProduct].length; ++k1) {
                        double predScore = score[pos - 1][predProduct][k1] + windowScore[pos][product];
                        for (int k2 = 0; k2 < score[pos][product].length; ++k2) {
                            if (!(predScore > score[pos][product][k2])) continue;
                            System.arraycopy(score[pos][product], k2, score[pos][product], k2 + 1, score[pos][product].length - (k2 + 1));
                            System.arraycopy(trace[pos][product], k2, trace[pos][product], k2 + 1, trace[pos][product].length - (k2 + 1));
                            score[pos][product][k2] = predScore;
                            trace[pos][product][k2] = new int[2];
                            trace[pos][product][k2][0] = predProduct;
                            trace[pos][product][k2][1] = k1;
                            continue block14;
                        }
                    }
                }
            }
        }
        int[][] kBest = new int[k][padLength];
        int[] whichDerivation = new int[k];
        int[] bestCurrentProducts = new int[k];
        double[] bestFinalScores = new double[k];
        Arrays.fill(bestFinalScores, Double.NEGATIVE_INFINITY);
        for (int product3 = 0; product3 < productSizes[padLength - 1]; ++product3) {
            block17: for (int k13 = 0; k13 < score[padLength - 1][product3].length; ++k13) {
                for (int k2 = 0; k2 < bestFinalScores.length; ++k2) {
                    if (!(score[padLength - 1][product3][k13] > bestFinalScores[k2])) continue;
                    System.arraycopy(bestFinalScores, k13, bestFinalScores, k13 + 1, bestFinalScores.length - (k13 + 1));
                    System.arraycopy(whichDerivation, k13, whichDerivation, k13 + 1, whichDerivation.length - (k13 + 1));
                    System.arraycopy(bestCurrentProducts, k13, bestCurrentProducts, k13 + 1, bestCurrentProducts.length - (k13 + 1));
                    bestCurrentProducts[k2] = product3;
                    whichDerivation[k2] = k13;
                    bestFinalScores[k2] = score[padLength - 1][product3][k13];
                    continue block17;
                }
            }
        }
        int[] lastProducts = new int[k];
        System.arraycopy(bestCurrentProducts, 0, lastProducts, 0, lastProducts.length);
        for (int last = padLength - 1; last >= length - 1 && last >= 0; --last) {
            k1 = 0;
            while (k1 < lastProducts.length) {
                kBest[k1][last] = tags[last][lastProducts[k1] % tagNum[last]];
                int n = k1++;
                lastProducts[n] = lastProducts[n] / tagNum[last];
            }
        }
        for (int pos5 = padLength - 2; pos5 >= leftWindow; --pos5) {
            System.arraycopy(bestCurrentProducts, 0, lastProducts, 0, lastProducts.length);
            Arrays.fill(bestCurrentProducts, -1);
            for (k1 = 0; k1 < lastProducts.length; ++k1) {
                bestCurrentProducts[k1] = trace[pos5 + 1][lastProducts[k1]][whichDerivation[k1]][0];
                whichDerivation[k1] = trace[pos5 + 1][lastProducts[k1]][whichDerivation[k1]][1];
                kBest[k1][pos5 - leftWindow] = tags[pos5 - leftWindow][bestCurrentProducts[k1] / (productSizes[pos5] / tagNum[pos5 - leftWindow])];
            }
        }
        ClassicCounter<int[]> kBestWithScores = new ClassicCounter<int[]>();
        for (int i = 0; i < kBest.length; ++i) {
            if (!(bestFinalScores[i] > Double.NEGATIVE_INFINITY)) continue;
            kBestWithScores.setCount(kBest[i], bestFinalScores[i]);
        }
        return kBestWithScores;
    }
}

