theory question_74_0
imports Main

begin

typedecl entity
typedecl event

consts
  WoodFreePaper :: "entity ⇒ bool"
  Creating :: "event ⇒ bool"
  CuttingDown :: "event ⇒ bool"
  Patient :: "event ⇒ entity ⇒ bool"
  Dozens :: "num ⇒ bool"
  NonWoodFibers :: "entity ⇒ bool"
  Pulped :: "event ⇒ bool"
  Paper :: "entity ⇒ bool"
  For :: "event ⇒ entity ⇒ bool"
  Fibres :: "entity ⇒ bool"
  Saves :: "event ⇒ bool"
  Pulping :: "event ⇒ bool"

(* Explanation 1: creating wood-free paper does not require cutting down trees *)
axiomatization where
  explanation_1: "∀x y. WoodFreePaper x ∧ Creating y ⟶ ¬CuttingDown y ∧ Patient y Trees"

(* Explanation 2: Dozens of non-wood fibers are pulped for paper around the world. *)
axiomatization where
  explanation_2: "∃e x. Dozens (num_of e) ∧ NonWoodFibers x ∧ Pulped e ∧ Patient e x ∧ Paper Paper ∧ For e Paper"

theorem hypothesis:
  assumes asm: "Fibres x ∧ Paper y ∧ Trees z ∧ Pulping e ∧ Patient e x ∧ For e y"
  (* Hypothesis: Pulping fibers for paper saves trees. *)
  shows "Saves e ∧ Agent e z"
proof -
  from asm have "Pulping e ∧ Patient e x ∧ For e y" by simp
  then have "NonWoodFibers x" using explanation_2 by blast
  then have "¬CuttingDown e ∧ Patient e Trees" using explanation_1 by blast
  then have "Saves e" using Saves_def by blast
  have "Agent e Trees" using Patient_def by blast
  then show "Saves e ∧ Agent e Trees" by auto
qed

end
