theory question_81_4
imports Main

begin

typedecl entity
typedecl event

consts
  Bicycle :: "entity ⇒ bool"
  Bike :: "entity ⇒ bool"
  Person :: "entity ⇒ bool"
  OnBike :: "event ⇒ entity ⇒ entity ⇒ bool"
  OnBicycle :: "event ⇒ entity ⇒ entity ⇒ bool"
  CarryingBike :: "event ⇒ entity ⇒ bool"
  Outdoors :: "event ⇒ entity ⇒ bool"
  Wears :: "event ⇒ bool"
  Agent :: "event ⇒ entity ⇒ bool"
  Helmet :: "entity ⇒ bool"
  Jumps :: "event ⇒ bool"
  Soaring :: "event ⇒ bool"
  Ground :: "entity ⇒ bool"
  InFrontOf :: "event ⇒ entity ⇒ entity ⇒ bool"
  Skyline :: "entity ⇒ bool"
  Lake :: "entity ⇒ bool"

(* Explanation 1: A bicycle is a type of bike. *)
axiomatization where
  explanation_1: "∀x. Bicycle x ⟶ Bike x"

(* Explanation 2: A person on a bike is outdoors. *)
axiomatization where
  explanation_2: "∀x y. Person x ∧ OnBike x y z ⟶ Outdoors y z"

(* Explanation 3: A person on a bike is equivalent to a person on a bicycle and carrying a bike. *)
axiomatization where
  explanation_3: "∀x. (PersonOnBike x ⟷ (PersonOnBicycle x ∧ CarryingBike x))"

theorem hypothesis:
  (* Premise: A person on a bicycle wears a helmet and jumps, soaring over the ground in front of a skyline and lake. *)
  assumes asm: "Person x ∧ Bicycle y ∧ Wears e1 ∧ Agent e1 x ∧ Helmet z ∧ OnBicycle e2 x y ∧ Jumps e2 ∧ Agent e2 x ∧ Soaring e2 ∧ Ground z1 ∧ InFrontOf e3 z1 l ∧ Skyline z2 ∧ Lake l ∧  l = z1 ∨ l = z2 "
  (* Hypothesis: A person outside with a bike. *)
  shows "∃x. Person x ∧ Outdoors e x ∧ Bike y ∧ Agent e x"
proof -
  from asm have "Person x" by auto
  from asm have "Bicycle y" by auto
  from asm have "OnBicycle e2 x y" by auto
  from asm have "Outdoors e2 y" using explanation_2 by blast
  then have "Outdoors e2 z1" using asm by auto
  show ?thesis using `Person x` `Outdoors e2 z1` `Bike y` `Agent e2 x` by blast
qed

end
