theory question_47_0

imports Main

begin

typedecl entity
typedecl event

consts
  Genes :: "entity ⇒ bool"
  SameChromosome :: "entity ⇒ entity ⇒ bool"
  LinkedGenes :: "entity ⇒ entity ⇒ bool"
  Inherited :: "event ⇒ bool"
  Agent :: "event ⇒ entity ⇒ bool"

(* Explanation 1: Genes that are located on the same chromosome are called linked genes. *)
axiomatization where
  explanation_1: "∀x y. Genes x ∧ Genes y ∧ SameChromosome x y ⟶ LinkedGenes x y"

(* Explanation 2: Linked genes are inherited together. *)
axiomatization where
  explanation_2: "∀x y e. LinkedGenes x y ⟶ (∃e. Inherited e ∧ Agent e x ∧ Agent e y)"

theorem hypothesis:
  assumes asm: "Genes x ∧ Genes y ∧ SameChromosome x y"
  (* Hypothesis: Genes are inherited together if they are located on the same chromosome. *)
  shows "∃e. Inherited e ∧ Agent e x ∧ Agent e y"
proof -
  from asm have "Genes x" and "Genes y" and "SameChromosome x y" by simp
  then have "LinkedGenes x y" using explanation_1 by blast
  then obtain e where e: "Inherited e ∧ Agent e x ∧ Agent e y" using explanation_2 by blast
  show ?thesis using e by blast
qed

end
