theory question_94_1

imports Main

begin

typedecl entity
typedecl event

consts
 Boy :: "entity ⇒ bool"
 Building :: "entity ⇒ bool"
 Entering :: "event ⇒ bool"
 Agent :: "event ⇒ entity ⇒ bool"
 Patient :: "event ⇒ entity ⇒ bool"
 Near :: "entity ⇒ entity ⇒ bool"

(* Explanation 1: If a boy is entering a building, it can be assumed that he is inside the building. *)
axiomatization where
 explanation_1: "∀x y e. Boy x ∧ Building y ∧ Entering e ∧ Agent e x ≫ Inside x y"

theorem hypothesis:
 (* Premise: A little boy in a bathrobe sits on a bench near the shower in a bathroom. *)
 assumes asm: "Boy x  ∧ Bathrobe y  ∧ Bench z  ∧ Shower z  ∧ Sitting e  ∧ Agent e  x  ∧ Patient e  z  ∧ Near z  y "
 (* Hypothesis: The boy is inside of the building. *)
 shows "∃x y e. Boy x ∧ Building y ∧ Entering e ∧ Agent e x"
proof -
 from asm have "Boy x" by blast
 from this have "Building y" using explanation_1 by blast
 then have "Entering e" using premise by blast
 then show ?thesis using `Boy x` `Building y` `Entering e` by blast
qed

end
