theory question_49_8
imports Main
begin

typedecl entity
typedecl event

consts
  Sun :: "entity ⇒ bool"
  Puddle :: "entity ⇒ bool"
  Time :: "entity ⇒ entity ⇒ bool"
  Shines :: "event ⇒ bool"
  Agent :: "event ⇒ entity ⇒ bool"
  Patient :: "event ⇒ entity ⇒ bool"
  PeriodOf :: "event ⇒ entity ⇒ bool"
  Disappears :: "event ⇒ bool"
  Water :: "entity ⇒ bool"
  Shining :: "event ⇒ bool"
  Evaporated :: "event ⇒ bool"
  BodyOfWater :: "entity ⇒ bool"
  Loses :: "event ⇒ bool"
  DueTo :: "event ⇒ entity ⇒ entity ⇒ bool"
  Exist :: "event ⇒ entity ⇒ bool"
  Evaporation :: "entity ⇒ bool"
  On :: "event ⇒ entity ⇒ bool"
  Disappeared :: "event ⇒ bool"
  Road :: "entity ⇒ bool"

(* Explanation 1: If the sun shines on a puddle for a certain period of time, the puddle disappears. *)
axiomatization where
  explanation_1: "∀x y z e1 e2. Sun x ∧ Puddle y ∧ Time z ∧ Shines e1 ∧ Agent e1 x ∧ Patient e1 y ∧ PeriodOf e1 z ⟶ Disappears e2 ∧ Patient e2 y"

(* Explanation 2: If a puddle disappears while the sun is shining for a certain period of time, then the water in the puddle has evaporated. *)
axiomatization where
  explanation_2: "∀x y z w e1 e2 e3. Sun x ∧ Puddle y ∧ Water z ∧ Time w ∧ Disappears e1 ∧ Patient e1 y ∧ Shining e2 ∧ Agent e2 x ∧ PeriodOf e2 w ⟶ Evaporated e3 ∧ Patient e3 z"

(* Explanation 3: If a body of water loses all water due to evaporation, then that body of water does not exist any more. *)
axiomatization where
  explanation_3: "∀x y e1 e2. BodyOfWater x ∧ Water y ∧ Loses e1 ∧ Agent e1 x ∧ Patient e1 y ∧ DueTo e1 x Evaporation ⟶ ¬Exist e2 x"

theorem hypothesis:
  (* Premise: at 10 a.m. the sun is shining on a puddle of water on the road. *)
  (* Premise: at 2 p.m. the sun is still shining and the puddle has disappeared. *)
  assumes asm: "Sun x ∧ Puddle y ∧ Road z ∧ Time e 10AM ∧ Shining e ∧ Agent e x ∧ Patient e y ∧ On e z" 
                "∃x y e1 e2. Sun x ∧ Puddle y ∧ Time e1 2PM ∧ Shining e1 ∧ Agent e1 x ∧ Disappeared e2 ∧ Patient e2 y"
  (* Hypothesis: The water evaporated. *)
  shows "∃x e. Water x ∧ Evaporated e ∧ Patient e x"
proof -
  from asm obtain e1 where e1: "Disappeared e1 ∧ Patient e1 y" by blast
  then have "Disappears e1 ∧ Patient e1 y" using explanation_1 by blast
  then obtain e2 where e2: "Evaporated e2 ∧ Patient e2 y" using explanation_2 by blast
  then have "¬Exist e1 y" using explanation_3 by blast
  show ?thesis using asm e1 e2 `¬Exist e1 y` by blast
qed

end
