theory question_77_1

imports Main

begin

typedecl entity

consts
  Mollusks :: "entity ⇒ bool"
  Shell :: "entity ⇒ bool"
  Mussels :: "entity ⇒ bool"
  BivalveMollusks :: "entity ⇒ bool"

(* Explanation 1: Most mollusks have shells. *)
axiomatization where
  explanation_1: "∀x. Mollusks x ⟶ Shell x"

(* Explanation 2: Mussels are bivalve mollusks, and all bivalve mollusks are mollusks. *)
axiomatization where
  explanation_2: "∀x. Mussels x ⟶ BivalveMollusks x" and
  explanation_3: "∀y. BivalveMollusks y ⟶ Mollusks y"  

theorem hypothesis:
  assumes asm: "Mussels x"
  (* Hypothesis: Mussels have a shell. *)
  shows "Shell x"
proof -
  from asm have "Mussels x" by simp
  then have "BivalveMollusks x" using explanation_2 by blast
  then have "Mollusks x" using explanation_3 by blast
  then show ?thesis using explanation_1 by blast
qed

end
