theory question_12_0
imports Main

begin

typedecl entity
typedecl event

consts
  Biofuel :: "entity ⇒ bool"
  Electricity :: "entity ⇒ bool"
  Burning :: "event ⇒ bool"
  Agent :: "event ⇒ entity ⇒ bool"
  Produce :: "event ⇒ bool"
  Patient :: "event ⇒ entity ⇒ bool"
  Ethanol :: "entity ⇒ bool"

(* Explanation 1: biofuel is used to produce electricity by burning *)
axiomatization where
  explanation_1: "∀x y e1 e2. Biofuel x ∧ Electricity y ∧ Burning e1 ∧ Agent e1 x ⟶ Produce e2 ∧ Agent e2 x ∧ Patient e2 y"

(* Explanation 2: Ethanol is the most widely used biofuel today. *)
axiomatization where
  explanation_2: "∀x. Ethanol x ⟶ Biofuel x"  

theorem hypothesis:
  assumes asm: "Ethanol x"
  (* Hypothesis: Burning ethanol is used to produce electricity. *)
  shows "∃x y e1 e2. Ethanol x ∧ Electricity y ∧ Burning e1 ∧ Agent e1 x ∧ Produce e2 ∧ Agent e2 x ∧ Patient e2 y"
proof -
  from asm have "Ethanol x" by simp
  then have "Biofuel x" using explanation_2 by blast
  then obtain y e1 e2 where "Electricity y ∧ Burning e1 ∧ Agent e1 x ∧ Produce e2 ∧ Agent e2 x ∧ Patient e2 y" using explanation_1 by blast
  then show ?thesis using asm by blast
qed

end
